/*
 * Decompiled with CFR 0.152.
 */
package org.signal.libsignal.internal;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.file.Files;
import java.nio.file.attribute.FileAttribute;
import java.util.Map;
import java.util.UUID;
import org.signal.libsignal.protocol.groups.state.SenderKeyStore;
import org.signal.libsignal.protocol.logging.Log;
import org.signal.libsignal.protocol.message.CiphertextMessage;
import org.signal.libsignal.protocol.state.IdentityKeyStore;
import org.signal.libsignal.protocol.state.KyberPreKeyStore;
import org.signal.libsignal.protocol.state.PreKeyStore;
import org.signal.libsignal.protocol.state.SessionStore;
import org.signal.libsignal.protocol.state.SignedPreKeyStore;

public final class Native {
    private static void copyToTempFileAndLoad(InputStream in, String name) throws IOException {
        File tempFile = Files.createTempFile(null, name, new FileAttribute[0]).toFile();
        tempFile.deleteOnExit();
        try (FileOutputStream out = new FileOutputStream(tempFile);){
            int read;
            byte[] buffer = new byte[4096];
            while ((read = in.read(buffer)) != -1) {
                ((OutputStream)out).write(buffer, 0, read);
            }
        }
        System.load(tempFile.getAbsolutePath());
    }

    private static void loadLibrary() {
        try {
            String libraryName = System.mapLibraryName("signal_jni");
            try (InputStream in = Native.class.getResourceAsStream("/" + libraryName);){
                if (in != null) {
                    Native.copyToTempFileAndLoad(in, libraryName);
                } else {
                    System.loadLibrary("signal_jni");
                }
            }
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    private Native() {
    }

    public static native void keepAlive(Object var0);

    public static native void Aes256Ctr32_Destroy(long var0);

    public static native long Aes256Ctr32_New(byte[] var0, byte[] var1, int var2);

    public static native void Aes256Ctr32_Process(long var0, byte[] var2, int var3, int var4);

    public static native void Aes256GcmDecryption_Destroy(long var0);

    public static native long Aes256GcmDecryption_New(byte[] var0, byte[] var1, byte[] var2);

    public static native void Aes256GcmDecryption_Update(long var0, byte[] var2, int var3, int var4);

    public static native boolean Aes256GcmDecryption_VerifyTag(long var0, byte[] var2);

    public static native byte[] Aes256GcmEncryption_ComputeTag(long var0);

    public static native void Aes256GcmEncryption_Destroy(long var0);

    public static native long Aes256GcmEncryption_New(byte[] var0, byte[] var1, byte[] var2);

    public static native void Aes256GcmEncryption_Update(long var0, byte[] var2, int var3, int var4);

    public static native byte[] Aes256GcmSiv_Decrypt(long var0, byte[] var2, byte[] var3, byte[] var4);

    public static native void Aes256GcmSiv_Destroy(long var0);

    public static native byte[] Aes256GcmSiv_Encrypt(long var0, byte[] var2, byte[] var3, byte[] var4);

    public static native long Aes256GcmSiv_New(byte[] var0);

    public static native void AuthCredentialPresentation_CheckValidContents(byte[] var0);

    public static native byte[] AuthCredentialPresentation_GetPniCiphertext(byte[] var0);

    public static native long AuthCredentialPresentation_GetRedemptionTime(byte[] var0);

    public static native byte[] AuthCredentialPresentation_GetUuidCiphertext(byte[] var0);

    public static native void AuthCredentialResponse_CheckValidContents(byte[] var0);

    public static native void AuthCredentialWithPniResponse_CheckValidContents(byte[] var0);

    public static native void AuthCredentialWithPni_CheckValidContents(byte[] var0);

    public static native void AuthCredential_CheckValidContents(byte[] var0);

    public static native void CallLinkAuthCredentialPresentation_CheckValidContents(byte[] var0);

    public static native byte[] CallLinkAuthCredentialPresentation_GetUserId(byte[] var0);

    public static native void CallLinkAuthCredentialPresentation_Verify(byte[] var0, long var1, byte[] var3, byte[] var4);

    public static native void CallLinkAuthCredentialResponse_CheckValidContents(byte[] var0);

    public static native byte[] CallLinkAuthCredentialResponse_IssueDeterministic(byte[] var0, long var1, byte[] var3, byte[] var4);

    public static native byte[] CallLinkAuthCredentialResponse_Receive(byte[] var0, byte[] var1, long var2, byte[] var4);

    public static native void CallLinkAuthCredential_CheckValidContents(byte[] var0);

    public static native byte[] CallLinkAuthCredential_PresentDeterministic(byte[] var0, byte[] var1, long var2, byte[] var4, byte[] var5, byte[] var6);

    public static native void CallLinkPublicParams_CheckValidContents(byte[] var0);

    public static native void CallLinkSecretParams_CheckValidContents(byte[] var0);

    public static native byte[] CallLinkSecretParams_DecryptUserId(byte[] var0, byte[] var1);

    public static native byte[] CallLinkSecretParams_DeriveFromRootKey(byte[] var0);

    public static native byte[] CallLinkSecretParams_GetPublicParams(byte[] var0);

    public static native long Cds2ClientState_New(byte[] var0, byte[] var1, long var2);

    public static native Map Cds2Metrics_extract(byte[] var0);

    public static native void CreateCallLinkCredentialPresentation_CheckValidContents(byte[] var0);

    public static native void CreateCallLinkCredentialPresentation_Verify(byte[] var0, byte[] var1, long var2, byte[] var4, byte[] var5);

    public static native void CreateCallLinkCredentialRequestContext_CheckValidContents(byte[] var0);

    public static native byte[] CreateCallLinkCredentialRequestContext_GetRequest(byte[] var0);

    public static native byte[] CreateCallLinkCredentialRequestContext_NewDeterministic(byte[] var0, byte[] var1);

    public static native byte[] CreateCallLinkCredentialRequestContext_ReceiveResponse(byte[] var0, byte[] var1, byte[] var2, byte[] var3);

    public static native void CreateCallLinkCredentialRequest_CheckValidContents(byte[] var0);

    public static native byte[] CreateCallLinkCredentialRequest_IssueDeterministic(byte[] var0, byte[] var1, long var2, byte[] var4, byte[] var5);

    public static native void CreateCallLinkCredentialResponse_CheckValidContents(byte[] var0);

    public static native void CreateCallLinkCredential_CheckValidContents(byte[] var0);

    public static native byte[] CreateCallLinkCredential_PresentDeterministic(byte[] var0, byte[] var1, byte[] var2, byte[] var3, byte[] var4, byte[] var5);

    public static native void CryptographicHash_Destroy(long var0);

    public static native byte[] CryptographicHash_Finalize(long var0);

    public static native long CryptographicHash_New(String var0);

    public static native void CryptographicHash_Update(long var0, byte[] var2);

    public static native void CryptographicHash_UpdateWithOffset(long var0, byte[] var2, int var3, int var4);

    public static native void CryptographicMac_Destroy(long var0);

    public static native byte[] CryptographicMac_Finalize(long var0);

    public static native long CryptographicMac_New(String var0, byte[] var1);

    public static native void CryptographicMac_Update(long var0, byte[] var2);

    public static native void CryptographicMac_UpdateWithOffset(long var0, byte[] var2, int var3, int var4);

    public static native long DecryptionErrorMessage_Deserialize(byte[] var0);

    public static native void DecryptionErrorMessage_Destroy(long var0);

    public static native long DecryptionErrorMessage_ExtractFromSerializedContent(byte[] var0);

    public static native long DecryptionErrorMessage_ForOriginalMessage(byte[] var0, int var1, long var2, int var4);

    public static native int DecryptionErrorMessage_GetDeviceId(long var0);

    public static native long DecryptionErrorMessage_GetRatchetKey(long var0);

    public static native byte[] DecryptionErrorMessage_GetSerialized(long var0);

    public static native long DecryptionErrorMessage_GetTimestamp(long var0);

    public static native byte[] DeviceTransfer_GenerateCertificate(byte[] var0, String var1, int var2);

    public static native byte[] DeviceTransfer_GeneratePrivateKey();

    public static native byte[] ECPrivateKey_Agree(long var0, long var2);

    public static native long ECPrivateKey_Deserialize(byte[] var0);

    public static native void ECPrivateKey_Destroy(long var0);

    public static native long ECPrivateKey_Generate();

    public static native long ECPrivateKey_GetPublicKey(long var0);

    public static native byte[] ECPrivateKey_Serialize(long var0);

    public static native byte[] ECPrivateKey_Sign(long var0, byte[] var2);

    public static native int ECPublicKey_Compare(long var0, long var2);

    public static native long ECPublicKey_Deserialize(byte[] var0, int var1);

    public static native void ECPublicKey_Destroy(long var0);

    public static native boolean ECPublicKey_Equals(long var0, long var2);

    public static native byte[] ECPublicKey_GetPublicKeyBytes(long var0);

    public static native byte[] ECPublicKey_Serialize(long var0);

    public static native boolean ECPublicKey_Verify(long var0, byte[] var2, byte[] var3);

    public static native void ExpiringProfileKeyCredentialResponse_CheckValidContents(byte[] var0);

    public static native void ExpiringProfileKeyCredential_CheckValidContents(byte[] var0);

    public static native long ExpiringProfileKeyCredential_GetExpirationTime(byte[] var0);

    public static native void GenericServerPublicParams_CheckValidContents(byte[] var0);

    public static native void GenericServerSecretParams_CheckValidContents(byte[] var0);

    public static native byte[] GenericServerSecretParams_GenerateDeterministic(byte[] var0);

    public static native byte[] GenericServerSecretParams_GetPublicParams(byte[] var0);

    public static native byte[] GroupCipher_DecryptMessage(long var0, byte[] var2, SenderKeyStore var3, Object var4);

    public static native CiphertextMessage GroupCipher_EncryptMessage(long var0, UUID var2, byte[] var3, SenderKeyStore var4, Object var5);

    public static native void GroupMasterKey_CheckValidContents(byte[] var0);

    public static native void GroupPublicParams_CheckValidContents(byte[] var0);

    public static native byte[] GroupPublicParams_GetGroupIdentifier(byte[] var0);

    public static native void GroupSecretParams_CheckValidContents(byte[] var0);

    public static native byte[] GroupSecretParams_DecryptBlobWithPadding(byte[] var0, byte[] var1);

    public static native byte[] GroupSecretParams_DecryptProfileKey(byte[] var0, byte[] var1, byte[] var2);

    public static native byte[] GroupSecretParams_DecryptServiceId(byte[] var0, byte[] var1);

    public static native byte[] GroupSecretParams_DeriveFromMasterKey(byte[] var0);

    public static native byte[] GroupSecretParams_EncryptBlobWithPaddingDeterministic(byte[] var0, byte[] var1, byte[] var2, int var3);

    public static native byte[] GroupSecretParams_EncryptProfileKey(byte[] var0, byte[] var1, byte[] var2);

    public static native byte[] GroupSecretParams_EncryptServiceId(byte[] var0, byte[] var1);

    public static native byte[] GroupSecretParams_GenerateDeterministic(byte[] var0);

    public static native byte[] GroupSecretParams_GetMasterKey(byte[] var0);

    public static native byte[] GroupSecretParams_GetPublicParams(byte[] var0);

    public static native long GroupSessionBuilder_CreateSenderKeyDistributionMessage(long var0, UUID var2, SenderKeyStore var3, Object var4);

    public static native void GroupSessionBuilder_ProcessSenderKeyDistributionMessage(long var0, long var2, SenderKeyStore var4, Object var5);

    public static native byte[] HKDF_DeriveSecrets(int var0, byte[] var1, byte[] var2, byte[] var3);

    public static native void HsmEnclaveClient_CompleteHandshake(long var0, byte[] var2);

    public static native void HsmEnclaveClient_Destroy(long var0);

    public static native byte[] HsmEnclaveClient_EstablishedRecv(long var0, byte[] var2);

    public static native byte[] HsmEnclaveClient_EstablishedSend(long var0, byte[] var2);

    public static native byte[] HsmEnclaveClient_InitialRequest(long var0);

    public static native long HsmEnclaveClient_New(byte[] var0, byte[] var1);

    public static native long[] IdentityKeyPair_Deserialize(byte[] var0);

    public static native byte[] IdentityKeyPair_Serialize(long var0, long var2);

    public static native byte[] IdentityKeyPair_SignAlternateIdentity(long var0, long var2, long var4);

    public static native boolean IdentityKey_VerifyAlternateIdentity(long var0, long var2, byte[] var4);

    public static native int IncrementalMac_CalculateChunkSize(int var0);

    public static native void IncrementalMac_Destroy(long var0);

    public static native byte[] IncrementalMac_Finalize(long var0);

    public static native long IncrementalMac_Initialize(byte[] var0, int var1);

    public static native byte[] IncrementalMac_Update(long var0, byte[] var2, int var3, int var4);

    public static native void KyberKeyPair_Destroy(long var0);

    public static native long KyberKeyPair_Generate();

    public static native long KyberKeyPair_GetPublicKey(long var0);

    public static native long KyberKeyPair_GetSecretKey(long var0);

    public static native long KyberPreKeyRecord_Deserialize(byte[] var0);

    public static native void KyberPreKeyRecord_Destroy(long var0);

    public static native int KyberPreKeyRecord_GetId(long var0);

    public static native long KyberPreKeyRecord_GetKeyPair(long var0);

    public static native long KyberPreKeyRecord_GetPublicKey(long var0);

    public static native long KyberPreKeyRecord_GetSecretKey(long var0);

    public static native byte[] KyberPreKeyRecord_GetSerialized(long var0);

    public static native byte[] KyberPreKeyRecord_GetSignature(long var0);

    public static native long KyberPreKeyRecord_GetTimestamp(long var0);

    public static native long KyberPreKeyRecord_New(int var0, long var1, long var3, byte[] var5);

    public static native long KyberPublicKey_DeserializeWithOffset(byte[] var0, int var1);

    public static native void KyberPublicKey_Destroy(long var0);

    public static native boolean KyberPublicKey_Equals(long var0, long var2);

    public static native byte[] KyberPublicKey_Serialize(long var0);

    public static native long KyberSecretKey_Deserialize(byte[] var0);

    public static native void KyberSecretKey_Destroy(long var0);

    public static native byte[] KyberSecretKey_Serialize(long var0);

    public static native void Logger_Initialize(int var0, Class var1);

    public static native void Logger_SetMaxLevel(int var0);

    public static native long Mp4Sanitizer_Sanitize(InputStream var0, long var1);

    public static native void NumericFingerprintGenerator_Destroy(long var0);

    public static native String NumericFingerprintGenerator_GetDisplayString(long var0);

    public static native byte[] NumericFingerprintGenerator_GetScannableEncoding(long var0);

    public static native long NumericFingerprintGenerator_New(int var0, int var1, byte[] var2, byte[] var3, byte[] var4, byte[] var5);

    public static native byte[] PinHash_AccessKey(long var0);

    public static native void PinHash_Destroy(long var0);

    public static native byte[] PinHash_EncryptionKey(long var0);

    public static native long PinHash_FromSalt(byte[] var0, byte[] var1);

    public static native long PinHash_FromUsernameMrenclave(byte[] var0, String var1, byte[] var2);

    public static native String Pin_LocalHash(byte[] var0);

    public static native boolean Pin_VerifyLocalHash(String var0, byte[] var1);

    public static native long PlaintextContent_Deserialize(byte[] var0);

    public static native byte[] PlaintextContent_DeserializeAndGetContent(byte[] var0);

    public static native void PlaintextContent_Destroy(long var0);

    public static native long PlaintextContent_FromDecryptionErrorMessage(long var0);

    public static native byte[] PlaintextContent_GetBody(long var0);

    public static native byte[] PlaintextContent_GetSerialized(long var0);

    public static native void PreKeyBundle_Destroy(long var0);

    public static native int PreKeyBundle_GetDeviceId(long var0);

    public static native long PreKeyBundle_GetIdentityKey(long var0);

    public static native int PreKeyBundle_GetKyberPreKeyId(long var0);

    public static native long PreKeyBundle_GetKyberPreKeyPublic(long var0);

    public static native byte[] PreKeyBundle_GetKyberPreKeySignature(long var0);

    public static native int PreKeyBundle_GetPreKeyId(long var0);

    public static native long PreKeyBundle_GetPreKeyPublic(long var0);

    public static native int PreKeyBundle_GetRegistrationId(long var0);

    public static native int PreKeyBundle_GetSignedPreKeyId(long var0);

    public static native long PreKeyBundle_GetSignedPreKeyPublic(long var0);

    public static native byte[] PreKeyBundle_GetSignedPreKeySignature(long var0);

    public static native long PreKeyBundle_New(int var0, int var1, int var2, long var3, int var5, long var6, byte[] var8, long var9, int var11, long var12, byte[] var14);

    public static native long PreKeyRecord_Deserialize(byte[] var0);

    public static native void PreKeyRecord_Destroy(long var0);

    public static native int PreKeyRecord_GetId(long var0);

    public static native long PreKeyRecord_GetPrivateKey(long var0);

    public static native long PreKeyRecord_GetPublicKey(long var0);

    public static native byte[] PreKeyRecord_GetSerialized(long var0);

    public static native long PreKeyRecord_New(int var0, long var1, long var3);

    public static native long PreKeySignalMessage_Deserialize(byte[] var0);

    public static native void PreKeySignalMessage_Destroy(long var0);

    public static native long PreKeySignalMessage_GetBaseKey(long var0);

    public static native long PreKeySignalMessage_GetIdentityKey(long var0);

    public static native int PreKeySignalMessage_GetPreKeyId(long var0);

    public static native int PreKeySignalMessage_GetRegistrationId(long var0);

    public static native byte[] PreKeySignalMessage_GetSerialized(long var0);

    public static native long PreKeySignalMessage_GetSignalMessage(long var0);

    public static native int PreKeySignalMessage_GetSignedPreKeyId(long var0);

    public static native int PreKeySignalMessage_GetVersion(long var0);

    public static native long PreKeySignalMessage_New(int var0, int var1, int var2, int var3, long var4, long var6, long var8);

    public static native void ProfileKeyCiphertext_CheckValidContents(byte[] var0);

    public static native void ProfileKeyCommitment_CheckValidContents(byte[] var0);

    public static native void ProfileKeyCredentialPresentation_CheckValidContents(byte[] var0);

    public static native byte[] ProfileKeyCredentialPresentation_GetProfileKeyCiphertext(byte[] var0);

    public static native byte[] ProfileKeyCredentialPresentation_GetStructurallyValidV1PresentationBytes(byte[] var0);

    public static native byte[] ProfileKeyCredentialPresentation_GetUuidCiphertext(byte[] var0);

    public static native void ProfileKeyCredentialRequestContext_CheckValidContents(byte[] var0);

    public static native byte[] ProfileKeyCredentialRequestContext_GetRequest(byte[] var0);

    public static native void ProfileKeyCredentialRequest_CheckValidContents(byte[] var0);

    public static native void ProfileKey_CheckValidContents(byte[] var0);

    public static native byte[] ProfileKey_DeriveAccessKey(byte[] var0);

    public static native byte[] ProfileKey_GetCommitment(byte[] var0, byte[] var1);

    public static native byte[] ProfileKey_GetProfileKeyVersion(byte[] var0, byte[] var1);

    public static native void ProtocolAddress_Destroy(long var0);

    public static native int ProtocolAddress_DeviceId(long var0);

    public static native String ProtocolAddress_Name(long var0);

    public static native long ProtocolAddress_New(String var0, int var1);

    public static native void ReceiptCredentialPresentation_CheckValidContents(byte[] var0);

    public static native long ReceiptCredentialPresentation_GetReceiptExpirationTime(byte[] var0);

    public static native long ReceiptCredentialPresentation_GetReceiptLevel(byte[] var0);

    public static native byte[] ReceiptCredentialPresentation_GetReceiptSerial(byte[] var0);

    public static native void ReceiptCredentialRequestContext_CheckValidContents(byte[] var0);

    public static native byte[] ReceiptCredentialRequestContext_GetRequest(byte[] var0);

    public static native void ReceiptCredentialRequest_CheckValidContents(byte[] var0);

    public static native void ReceiptCredentialResponse_CheckValidContents(byte[] var0);

    public static native void ReceiptCredential_CheckValidContents(byte[] var0);

    public static native long ReceiptCredential_GetReceiptExpirationTime(byte[] var0);

    public static native long ReceiptCredential_GetReceiptLevel(byte[] var0);

    public static native void SanitizedMetadata_Destroy(long var0);

    public static native long SanitizedMetadata_GetDataLen(long var0);

    public static native long SanitizedMetadata_GetDataOffset(long var0);

    public static native byte[] SanitizedMetadata_GetMetadata(long var0);

    public static native boolean ScannableFingerprint_Compare(byte[] var0, byte[] var1);

    public static native long SealedSessionCipher_DecryptToUsmc(byte[] var0, IdentityKeyStore var1, Object var2);

    public static native byte[] SealedSessionCipher_Encrypt(long var0, long var2, IdentityKeyStore var4, Object var5);

    public static native byte[] SealedSessionCipher_MultiRecipientEncrypt(long[] var0, long[] var1, long var2, IdentityKeyStore var4, Object var5);

    public static native byte[] SealedSessionCipher_MultiRecipientMessageForSingleRecipient(byte[] var0);

    public static native long SenderCertificate_Deserialize(byte[] var0);

    public static native void SenderCertificate_Destroy(long var0);

    public static native byte[] SenderCertificate_GetCertificate(long var0);

    public static native int SenderCertificate_GetDeviceId(long var0);

    public static native long SenderCertificate_GetExpiration(long var0);

    public static native long SenderCertificate_GetKey(long var0);

    public static native String SenderCertificate_GetSenderE164(long var0);

    public static native String SenderCertificate_GetSenderUuid(long var0);

    public static native byte[] SenderCertificate_GetSerialized(long var0);

    public static native long SenderCertificate_GetServerCertificate(long var0);

    public static native byte[] SenderCertificate_GetSignature(long var0);

    public static native long SenderCertificate_New(String var0, String var1, int var2, long var3, long var5, long var7, long var9);

    public static native boolean SenderCertificate_Validate(long var0, long var2, long var4);

    public static native long SenderKeyDistributionMessage_Deserialize(byte[] var0);

    public static native void SenderKeyDistributionMessage_Destroy(long var0);

    public static native int SenderKeyDistributionMessage_GetChainId(long var0);

    public static native byte[] SenderKeyDistributionMessage_GetChainKey(long var0);

    public static native UUID SenderKeyDistributionMessage_GetDistributionId(long var0);

    public static native int SenderKeyDistributionMessage_GetIteration(long var0);

    public static native byte[] SenderKeyDistributionMessage_GetSerialized(long var0);

    public static native long SenderKeyDistributionMessage_GetSignatureKey(long var0);

    public static native long SenderKeyDistributionMessage_New(int var0, UUID var1, int var2, int var3, byte[] var4, long var5);

    public static native long SenderKeyMessage_Deserialize(byte[] var0);

    public static native void SenderKeyMessage_Destroy(long var0);

    public static native int SenderKeyMessage_GetChainId(long var0);

    public static native byte[] SenderKeyMessage_GetCipherText(long var0);

    public static native UUID SenderKeyMessage_GetDistributionId(long var0);

    public static native int SenderKeyMessage_GetIteration(long var0);

    public static native byte[] SenderKeyMessage_GetSerialized(long var0);

    public static native long SenderKeyMessage_New(int var0, UUID var1, int var2, int var3, byte[] var4, long var5);

    public static native boolean SenderKeyMessage_VerifySignature(long var0, long var2);

    public static native long SenderKeyRecord_Deserialize(byte[] var0);

    public static native void SenderKeyRecord_Destroy(long var0);

    public static native byte[] SenderKeyRecord_GetSerialized(long var0);

    public static native long ServerCertificate_Deserialize(byte[] var0);

    public static native void ServerCertificate_Destroy(long var0);

    public static native byte[] ServerCertificate_GetCertificate(long var0);

    public static native long ServerCertificate_GetKey(long var0);

    public static native int ServerCertificate_GetKeyId(long var0);

    public static native byte[] ServerCertificate_GetSerialized(long var0);

    public static native byte[] ServerCertificate_GetSignature(long var0);

    public static native long ServerCertificate_New(int var0, long var1, long var3);

    public static native void ServerPublicParams_CheckValidContents(byte[] var0);

    public static native byte[] ServerPublicParams_CreateAuthCredentialPresentationDeterministic(byte[] var0, byte[] var1, byte[] var2, byte[] var3);

    public static native byte[] ServerPublicParams_CreateAuthCredentialWithPniPresentationDeterministic(byte[] var0, byte[] var1, byte[] var2, byte[] var3);

    public static native byte[] ServerPublicParams_CreateExpiringProfileKeyCredentialPresentationDeterministic(byte[] var0, byte[] var1, byte[] var2, byte[] var3);

    public static native byte[] ServerPublicParams_CreateProfileKeyCredentialRequestContextDeterministic(byte[] var0, byte[] var1, byte[] var2, byte[] var3);

    public static native byte[] ServerPublicParams_CreateReceiptCredentialPresentationDeterministic(byte[] var0, byte[] var1, byte[] var2);

    public static native byte[] ServerPublicParams_CreateReceiptCredentialRequestContextDeterministic(byte[] var0, byte[] var1, byte[] var2);

    public static native byte[] ServerPublicParams_ReceiveAuthCredential(byte[] var0, byte[] var1, int var2, byte[] var3);

    public static native byte[] ServerPublicParams_ReceiveAuthCredentialWithPniAsAci(byte[] var0, byte[] var1, byte[] var2, long var3, byte[] var5);

    public static native byte[] ServerPublicParams_ReceiveAuthCredentialWithPniAsServiceId(byte[] var0, byte[] var1, byte[] var2, long var3, byte[] var5);

    public static native byte[] ServerPublicParams_ReceiveExpiringProfileKeyCredential(byte[] var0, byte[] var1, byte[] var2, long var3);

    public static native byte[] ServerPublicParams_ReceiveReceiptCredential(byte[] var0, byte[] var1, byte[] var2);

    public static native void ServerPublicParams_VerifySignature(byte[] var0, byte[] var1, byte[] var2);

    public static native void ServerSecretParams_CheckValidContents(byte[] var0);

    public static native byte[] ServerSecretParams_GenerateDeterministic(byte[] var0);

    public static native byte[] ServerSecretParams_GetPublicParams(byte[] var0);

    public static native byte[] ServerSecretParams_IssueAuthCredentialDeterministic(byte[] var0, byte[] var1, byte[] var2, int var3);

    public static native byte[] ServerSecretParams_IssueAuthCredentialWithPniAsAciDeterministic(byte[] var0, byte[] var1, byte[] var2, byte[] var3, long var4);

    public static native byte[] ServerSecretParams_IssueAuthCredentialWithPniAsServiceIdDeterministic(byte[] var0, byte[] var1, byte[] var2, byte[] var3, long var4);

    public static native byte[] ServerSecretParams_IssueExpiringProfileKeyCredentialDeterministic(byte[] var0, byte[] var1, byte[] var2, byte[] var3, byte[] var4, long var5);

    public static native byte[] ServerSecretParams_IssueReceiptCredentialDeterministic(byte[] var0, byte[] var1, byte[] var2, long var3, long var5);

    public static native byte[] ServerSecretParams_SignDeterministic(byte[] var0, byte[] var1, byte[] var2);

    public static native void ServerSecretParams_VerifyAuthCredentialPresentation(byte[] var0, byte[] var1, byte[] var2, long var3);

    public static native void ServerSecretParams_VerifyProfileKeyCredentialPresentation(byte[] var0, byte[] var1, byte[] var2, long var3);

    public static native void ServerSecretParams_VerifyReceiptCredentialPresentation(byte[] var0, byte[] var1);

    public static native byte[] ServiceId_ParseFromServiceIdBinary(byte[] var0);

    public static native byte[] ServiceId_ParseFromServiceIdString(String var0);

    public static native byte[] ServiceId_ServiceIdBinary(byte[] var0);

    public static native String ServiceId_ServiceIdLog(byte[] var0);

    public static native String ServiceId_ServiceIdString(byte[] var0);

    public static native void SessionBuilder_ProcessPreKeyBundle(long var0, long var2, SessionStore var4, IdentityKeyStore var5, Object var6);

    public static native byte[] SessionCipher_DecryptPreKeySignalMessage(long var0, long var2, SessionStore var4, IdentityKeyStore var5, PreKeyStore var6, SignedPreKeyStore var7, KyberPreKeyStore var8, Object var9);

    public static native byte[] SessionCipher_DecryptSignalMessage(long var0, long var2, SessionStore var4, IdentityKeyStore var5, Object var6);

    public static native CiphertextMessage SessionCipher_EncryptMessage(byte[] var0, long var1, SessionStore var3, IdentityKeyStore var4, Object var5);

    public static native void SessionRecord_ArchiveCurrentState(long var0);

    public static native boolean SessionRecord_CurrentRatchetKeyMatches(long var0, long var2);

    public static native long SessionRecord_Deserialize(byte[] var0);

    public static native void SessionRecord_Destroy(long var0);

    public static native long SessionRecord_FromSingleSessionState(byte[] var0);

    public static native byte[] SessionRecord_GetAliceBaseKey(long var0);

    public static native byte[] SessionRecord_GetLocalIdentityKeyPublic(long var0);

    public static native int SessionRecord_GetLocalRegistrationId(long var0);

    public static native byte[] SessionRecord_GetReceiverChainKeyValue(long var0, long var2);

    public static native byte[] SessionRecord_GetRemoteIdentityKeyPublic(long var0);

    public static native int SessionRecord_GetRemoteRegistrationId(long var0);

    public static native byte[] SessionRecord_GetSenderChainKeyValue(long var0);

    public static native int SessionRecord_GetSessionVersion(long var0);

    public static native boolean SessionRecord_HasSenderChain(long var0);

    public static native long SessionRecord_InitializeAliceSession(long var0, long var2, long var4, long var6, long var8, long var10, long var12);

    public static native long SessionRecord_InitializeBobSession(long var0, long var2, long var4, long var6, long var8, long var10, long var12, long var14);

    public static native long SessionRecord_NewFresh();

    public static native byte[] SessionRecord_Serialize(long var0);

    public static native void SgxClientState_CompleteHandshake(long var0, byte[] var2);

    public static native void SgxClientState_Destroy(long var0);

    public static native byte[] SgxClientState_EstablishedRecv(long var0, byte[] var2);

    public static native byte[] SgxClientState_EstablishedSend(long var0, byte[] var2);

    public static native byte[] SgxClientState_InitialRequest(long var0);

    public static native void SignalMedia_CheckAvailable();

    public static native long SignalMessage_Deserialize(byte[] var0);

    public static native void SignalMessage_Destroy(long var0);

    public static native byte[] SignalMessage_GetBody(long var0);

    public static native int SignalMessage_GetCounter(long var0);

    public static native int SignalMessage_GetMessageVersion(long var0);

    public static native long SignalMessage_GetSenderRatchetKey(long var0);

    public static native byte[] SignalMessage_GetSerialized(long var0);

    public static native long SignalMessage_New(int var0, byte[] var1, long var2, int var4, int var5, byte[] var6, long var7, long var9);

    public static native boolean SignalMessage_VerifyMac(long var0, long var2, long var4, byte[] var6);

    public static native long SignedPreKeyRecord_Deserialize(byte[] var0);

    public static native void SignedPreKeyRecord_Destroy(long var0);

    public static native int SignedPreKeyRecord_GetId(long var0);

    public static native long SignedPreKeyRecord_GetPrivateKey(long var0);

    public static native long SignedPreKeyRecord_GetPublicKey(long var0);

    public static native byte[] SignedPreKeyRecord_GetSerialized(long var0);

    public static native byte[] SignedPreKeyRecord_GetSignature(long var0);

    public static native long SignedPreKeyRecord_GetTimestamp(long var0);

    public static native long SignedPreKeyRecord_New(int var0, long var1, long var3, long var5, byte[] var7);

    public static native long Svr2Client_New(byte[] var0, byte[] var1, long var2);

    public static native long UnidentifiedSenderMessageContent_Deserialize(byte[] var0);

    public static native void UnidentifiedSenderMessageContent_Destroy(long var0);

    public static native int UnidentifiedSenderMessageContent_GetContentHint(long var0);

    public static native byte[] UnidentifiedSenderMessageContent_GetContents(long var0);

    public static native byte[] UnidentifiedSenderMessageContent_GetGroupId(long var0);

    public static native int UnidentifiedSenderMessageContent_GetMsgType(long var0);

    public static native long UnidentifiedSenderMessageContent_GetSenderCert(long var0);

    public static native byte[] UnidentifiedSenderMessageContent_GetSerialized(long var0);

    public static native long UnidentifiedSenderMessageContent_New(CiphertextMessage var0, long var1, int var3, byte[] var4);

    public static native byte[] UsernameLink_Create(String var0);

    public static native String UsernameLink_DecryptUsername(byte[] var0, byte[] var1);

    public static native String Username_CandidatesFrom(String var0, int var1, int var2);

    public static native byte[] Username_Hash(String var0);

    public static native byte[] Username_Proof(String var0, byte[] var1);

    public static native void Username_Verify(byte[] var0, byte[] var1);

    public static native void UuidCiphertext_CheckValidContents(byte[] var0);

    public static native void ValidatingMac_Destroy(long var0);

    public static native boolean ValidatingMac_Finalize(long var0);

    public static native long ValidatingMac_Initialize(byte[] var0, int var1, byte[] var2);

    public static native boolean ValidatingMac_Update(long var0, byte[] var2, int var3, int var4);

    static {
        Native.loadLibrary();
        Native.Logger_Initialize(4, Log.class);
    }
}

