/*
 * Decompiled with CFR 0.152.
 */
package org.signal.libsignal.protocol.state;

import org.signal.libsignal.internal.Native;
import org.signal.libsignal.internal.NativeHandleGuard;
import org.signal.libsignal.protocol.InvalidMessageException;
import org.signal.libsignal.protocol.kem.KEMKeyPair;

public class KyberPreKeyRecord
implements NativeHandleGuard.Owner {
    private final long unsafeHandle;

    protected void finalize() {
        Native.KyberPreKeyRecord_Destroy(this.unsafeHandle);
    }

    public KyberPreKeyRecord(int id, long timestamp, KEMKeyPair keyPair, byte[] signature) {
        try (NativeHandleGuard guard = new NativeHandleGuard(keyPair);){
            this.unsafeHandle = Native.KyberPreKeyRecord_New(id, timestamp, guard.nativeHandle(), signature);
        }
    }

    public KyberPreKeyRecord(byte[] serialized) throws InvalidMessageException {
        this.unsafeHandle = Native.KyberPreKeyRecord_Deserialize(serialized);
    }

    public int getId() {
        try (NativeHandleGuard guard = new NativeHandleGuard(this);){
            int n = Native.KyberPreKeyRecord_GetId(guard.nativeHandle());
            return n;
        }
    }

    public long getTimestamp() {
        try (NativeHandleGuard guard = new NativeHandleGuard(this);){
            long l = Native.KyberPreKeyRecord_GetTimestamp(guard.nativeHandle());
            return l;
        }
    }

    public KEMKeyPair getKeyPair() {
        try (NativeHandleGuard guard = new NativeHandleGuard(this);){
            KEMKeyPair kEMKeyPair = new KEMKeyPair(Native.KyberPreKeyRecord_GetKeyPair(guard.nativeHandle()));
            return kEMKeyPair;
        }
    }

    public byte[] getSignature() {
        try (NativeHandleGuard guard = new NativeHandleGuard(this);){
            byte[] byArray = Native.KyberPreKeyRecord_GetSignature(guard.nativeHandle());
            return byArray;
        }
    }

    public byte[] serialize() {
        try (NativeHandleGuard guard = new NativeHandleGuard(this);){
            byte[] byArray = Native.KyberPreKeyRecord_GetSerialized(guard.nativeHandle());
            return byArray;
        }
    }

    @Override
    public long unsafeNativeHandleWithoutGuard() {
        return this.unsafeHandle;
    }
}

