/*
 * Decompiled with CFR 0.152.
 */
package org.signal.libsignal.protocol.message;

import javax.crypto.spec.SecretKeySpec;
import org.signal.libsignal.internal.Native;
import org.signal.libsignal.internal.NativeHandleGuard;
import org.signal.libsignal.protocol.IdentityKey;
import org.signal.libsignal.protocol.InvalidKeyException;
import org.signal.libsignal.protocol.InvalidMessageException;
import org.signal.libsignal.protocol.InvalidVersionException;
import org.signal.libsignal.protocol.LegacyMessageException;
import org.signal.libsignal.protocol.ecc.ECPublicKey;
import org.signal.libsignal.protocol.message.CiphertextMessage;
import org.signal.libsignal.protocol.util.ByteUtil;

public class SignalMessage
implements CiphertextMessage,
NativeHandleGuard.Owner {
    private final long unsafeHandle;

    protected void finalize() {
        Native.SignalMessage_Destroy(this.unsafeHandle);
    }

    public SignalMessage(byte[] serialized) throws InvalidMessageException, InvalidVersionException, InvalidKeyException, LegacyMessageException {
        this.unsafeHandle = Native.SignalMessage_Deserialize(serialized);
    }

    public SignalMessage(long unsafeHandle) {
        this.unsafeHandle = unsafeHandle;
    }

    public ECPublicKey getSenderRatchetKey() {
        try (NativeHandleGuard guard = new NativeHandleGuard(this);){
            ECPublicKey eCPublicKey = new ECPublicKey(Native.SignalMessage_GetSenderRatchetKey(guard.nativeHandle()));
            return eCPublicKey;
        }
    }

    public int getMessageVersion() {
        try (NativeHandleGuard guard = new NativeHandleGuard(this);){
            int n = Native.SignalMessage_GetMessageVersion(guard.nativeHandle());
            return n;
        }
    }

    public int getCounter() {
        try (NativeHandleGuard guard = new NativeHandleGuard(this);){
            int n = Native.SignalMessage_GetCounter(guard.nativeHandle());
            return n;
        }
    }

    public byte[] getBody() {
        try (NativeHandleGuard guard = new NativeHandleGuard(this);){
            byte[] byArray = Native.SignalMessage_GetBody(guard.nativeHandle());
            return byArray;
        }
    }

    public void verifyMac(IdentityKey senderIdentityKey, IdentityKey receiverIdentityKey, SecretKeySpec macKey) throws InvalidMessageException, InvalidKeyException {
        try (NativeHandleGuard guard = new NativeHandleGuard(this);
             NativeHandleGuard senderIdentityGuard = new NativeHandleGuard(senderIdentityKey.getPublicKey());
             NativeHandleGuard receiverIdentityGuard = new NativeHandleGuard(receiverIdentityKey.getPublicKey());){
            if (!Native.SignalMessage_VerifyMac(guard.nativeHandle(), senderIdentityGuard.nativeHandle(), receiverIdentityGuard.nativeHandle(), macKey.getEncoded())) {
                throw new InvalidMessageException("Bad Mac!");
            }
        }
    }

    @Override
    public byte[] serialize() {
        try (NativeHandleGuard guard = new NativeHandleGuard(this);){
            byte[] byArray = Native.SignalMessage_GetSerialized(guard.nativeHandle());
            return byArray;
        }
    }

    @Override
    public int getType() {
        return 2;
    }

    @Override
    public long unsafeNativeHandleWithoutGuard() {
        return this.unsafeHandle;
    }

    public static boolean isLegacy(byte[] message) {
        return message != null && message.length >= 1 && ByteUtil.highBitsToInt(message[0]) != 3;
    }
}

