/*
 * Decompiled with CFR 0.152.
 */
package org.shredzone.commons.suncalc.util;

public class QuadraticInterpolation {
    private final double xe;
    private final double ye;
    private final double root1;
    private final double root2;
    private final int nRoot;
    private final boolean maximum;

    public QuadraticInterpolation(double yMinus, double y0, double yPlus) {
        double a = 0.5 * (yPlus + yMinus) - y0;
        double b = 0.5 * (yPlus - yMinus);
        double c = y0;
        this.xe = -b / (2.0 * a);
        this.ye = (a * this.xe + b) * this.xe + c;
        this.maximum = a < 0.0;
        double dis = b * b - 4.0 * a * c;
        int rootCount = 0;
        if (dis >= 0.0) {
            double dx = 0.5 * Math.sqrt(dis) / Math.abs(a);
            this.root1 = this.xe - dx;
            this.root2 = this.xe + dx;
            if (Math.abs(this.root1) <= 1.0) {
                ++rootCount;
            }
            if (Math.abs(this.root2) <= 1.0) {
                ++rootCount;
            }
        } else {
            this.root1 = Double.NaN;
            this.root2 = Double.NaN;
        }
        this.nRoot = rootCount;
    }

    public double getXe() {
        return this.xe;
    }

    public double getYe() {
        return this.ye;
    }

    public double getRoot1() {
        return this.root1 < -1.0 ? this.root2 : this.root1;
    }

    public double getRoot2() {
        return this.root2;
    }

    public int getNumberOfRoots() {
        return this.nRoot;
    }

    public boolean isMaximum() {
        return this.maximum;
    }
}

