/*
 * Decompiled with CFR 0.152.
 */
package org.shredzone.commons.suncalc.util;

import java.util.Arrays;
import org.shredzone.commons.suncalc.util.Vector;

public class Matrix {
    private final double[] mx;

    private Matrix() {
        this.mx = new double[9];
    }

    private Matrix(double ... values) {
        if (values == null || values.length != 9) {
            throw new IllegalArgumentException("requires 9 values");
        }
        this.mx = values;
    }

    public static Matrix identity() {
        return new Matrix(1.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 1.0);
    }

    public static Matrix rotateX(double angle) {
        double s = Math.sin(angle);
        double c = Math.cos(angle);
        return new Matrix(1.0, 0.0, 0.0, 0.0, c, s, 0.0, -s, c);
    }

    public static Matrix rotateY(double angle) {
        double s = Math.sin(angle);
        double c = Math.cos(angle);
        return new Matrix(c, 0.0, -s, 0.0, 1.0, 0.0, s, 0.0, c);
    }

    public static Matrix rotateZ(double angle) {
        double s = Math.sin(angle);
        double c = Math.cos(angle);
        return new Matrix(c, s, 0.0, -s, c, 0.0, 0.0, 0.0, 1.0);
    }

    public Matrix transpose() {
        Matrix result = new Matrix();
        for (int i = 0; i < 3; ++i) {
            for (int j = 0; j < 3; ++j) {
                result.set(i, j, this.get(j, i));
            }
        }
        return result;
    }

    public Matrix negate() {
        Matrix result = new Matrix();
        for (int i = 0; i < 9; ++i) {
            result.mx[i] = -this.mx[i];
        }
        return result;
    }

    public Matrix add(Matrix right) {
        Matrix result = new Matrix();
        for (int i = 0; i < 9; ++i) {
            result.mx[i] = this.mx[i] + right.mx[i];
        }
        return result;
    }

    public Matrix subtract(Matrix right) {
        Matrix result = new Matrix();
        for (int i = 0; i < 9; ++i) {
            result.mx[i] = this.mx[i] - right.mx[i];
        }
        return result;
    }

    public Matrix multiply(Matrix right) {
        Matrix result = new Matrix();
        for (int i = 0; i < 3; ++i) {
            for (int j = 0; j < 3; ++j) {
                double scalp = 0.0;
                for (int k = 0; k < 3; ++k) {
                    scalp += this.get(i, k) * right.get(k, j);
                }
                result.set(i, j, scalp);
            }
        }
        return result;
    }

    public Matrix multiply(double scalar) {
        Matrix result = new Matrix();
        for (int i = 0; i < 9; ++i) {
            result.mx[i] = this.mx[i] * scalar;
        }
        return result;
    }

    public Vector multiply(Vector right) {
        double[] vec = new double[]{right.getX(), right.getY(), right.getZ()};
        double[] result = new double[3];
        for (int i = 0; i < 3; ++i) {
            double scalp = 0.0;
            for (int j = 0; j < 3; ++j) {
                scalp += this.get(i, j) * vec[j];
            }
            result[i] = scalp;
        }
        return new Vector(result);
    }

    public double get(int r, int c) {
        if (r < 0 || r > 2 || c < 0 || c > 2) {
            throw new IllegalArgumentException("row/column out of range: " + r + ":" + c);
        }
        return this.mx[r * 3 + c];
    }

    private void set(int r, int c, double v) {
        if (r < 0 || r > 2 || c < 0 || c > 2) {
            throw new IllegalArgumentException("row/column out of range: " + r + ":" + c);
        }
        this.mx[r * 3 + c] = v;
    }

    public boolean equals(Object obj) {
        if (obj == null || !(obj instanceof Matrix)) {
            return false;
        }
        return Arrays.equals(this.mx, ((Matrix)obj).mx);
    }

    public int hashCode() {
        return Arrays.hashCode(this.mx);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append('[');
        for (int ix = 0; ix < 9; ++ix) {
            if (ix % 3 == 0) {
                sb.append('[');
            }
            sb.append(this.mx[ix]);
            if (ix % 3 == 2) {
                sb.append(']');
            }
            if (ix >= 8) continue;
            sb.append(", ");
        }
        sb.append(']');
        return sb.toString();
    }
}

