/*
 * Decompiled with CFR 0.152.
 */
package org.shredzone.commons.suncalc;

import org.shredzone.commons.suncalc.param.Builder;
import org.shredzone.commons.suncalc.param.GenericParameter;
import org.shredzone.commons.suncalc.param.LocationParameter;
import org.shredzone.commons.suncalc.param.TimeParameter;
import org.shredzone.commons.suncalc.util.BaseBuilder;
import org.shredzone.commons.suncalc.util.ExtendedMath;
import org.shredzone.commons.suncalc.util.JulianDate;
import org.shredzone.commons.suncalc.util.Sun;
import org.shredzone.commons.suncalc.util.Vector;

public class SunPosition {
    private final double azimuth;
    private final double altitude;
    private final double trueAltitude;
    private final double distance;

    private SunPosition(double azimuth, double altitude, double trueAltitude, double distance) {
        this.azimuth = (Math.toDegrees(azimuth) + 180.0) % 360.0;
        this.altitude = Math.toDegrees(altitude);
        this.trueAltitude = Math.toDegrees(trueAltitude);
        this.distance = distance;
    }

    public static Parameters compute() {
        return new SunPositionBuilder();
    }

    public double getAltitude() {
        return this.altitude;
    }

    public double getTrueAltitude() {
        return this.trueAltitude;
    }

    public double getAzimuth() {
        return this.azimuth;
    }

    public double getDistance() {
        return this.distance;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("SunPosition[azimuth=").append(this.azimuth);
        sb.append("\u00b0, altitude=").append(this.altitude);
        sb.append("\u00b0, true altitude=").append(this.trueAltitude);
        sb.append("\u00b0, distance=").append(this.distance).append(" km]");
        return sb.toString();
    }

    private static class SunPositionBuilder
    extends BaseBuilder<Parameters>
    implements Parameters {
        private SunPositionBuilder() {
        }

        @Override
        public SunPosition execute() {
            JulianDate t = this.getJulianDate();
            double lw = Math.toRadians(-this.getLongitude());
            double phi = Math.toRadians(this.getLatitude());
            Vector c = Sun.position(t);
            double h = t.getGreenwichMeanSiderealTime() - lw - c.getPhi();
            Vector horizontal = ExtendedMath.equatorialToHorizontal(h, c.getTheta(), c.getR(), phi);
            double hRef = ExtendedMath.refraction(horizontal.getTheta());
            return new SunPosition(horizontal.getPhi(), horizontal.getTheta() + hRef, horizontal.getTheta(), horizontal.getR());
        }
    }

    public static interface Parameters
    extends GenericParameter<Parameters>,
    LocationParameter<Parameters>,
    TimeParameter<Parameters>,
    Builder<SunPosition> {
    }
}

