/*
 * Decompiled with CFR 0.152.
 */
package org.shredzone.commons.suncalc;

import org.shredzone.commons.suncalc.param.Builder;
import org.shredzone.commons.suncalc.param.GenericParameter;
import org.shredzone.commons.suncalc.param.LocationParameter;
import org.shredzone.commons.suncalc.param.TimeParameter;
import org.shredzone.commons.suncalc.util.BaseBuilder;
import org.shredzone.commons.suncalc.util.ExtendedMath;
import org.shredzone.commons.suncalc.util.JulianDate;
import org.shredzone.commons.suncalc.util.Moon;
import org.shredzone.commons.suncalc.util.Vector;

public class MoonPosition {
    private final double azimuth;
    private final double altitude;
    private final double distance;
    private final double parallacticAngle;

    private MoonPosition(double azimuth, double altitude, double distance, double parallacticAngle) {
        this.azimuth = (Math.toDegrees(azimuth) + 180.0) % 360.0;
        this.altitude = Math.toDegrees(altitude);
        this.distance = distance;
        this.parallacticAngle = Math.toDegrees(parallacticAngle);
    }

    public static Parameters compute() {
        return new MoonPositionBuilder();
    }

    public double getAltitude() {
        return this.altitude;
    }

    public double getAzimuth() {
        return this.azimuth;
    }

    public double getDistance() {
        return this.distance;
    }

    public double getParallacticAngle() {
        return this.parallacticAngle;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("MoonPosition[azimuth=").append(this.azimuth);
        sb.append("\u00b0, altitude=").append(this.altitude);
        sb.append("\u00b0, distance=").append(this.distance);
        sb.append(" km, parallacticAngle=").append(this.parallacticAngle);
        sb.append("\u00b0]");
        return sb.toString();
    }

    private static class MoonPositionBuilder
    extends BaseBuilder<Parameters>
    implements Parameters {
        private MoonPositionBuilder() {
        }

        @Override
        public MoonPosition execute() {
            JulianDate t = this.getJulianDate();
            double phi = this.getLatitudeRad();
            double lambda = this.getLongitudeRad();
            Vector mc = Moon.position(t);
            double h = t.getGreenwichMeanSiderealTime() + lambda - mc.getPhi();
            Vector horizontal = ExtendedMath.equatorialToHorizontal(h, mc.getTheta(), mc.getR(), phi);
            double hRef = ExtendedMath.refraction(horizontal.getTheta());
            double pa = Math.atan2(Math.sin(h), Math.tan(phi) * Math.cos(mc.getTheta()) - Math.sin(mc.getTheta()) * Math.cos(h));
            return new MoonPosition(horizontal.getPhi(), horizontal.getTheta() + hRef, mc.getR(), pa);
        }
    }

    public static interface Parameters
    extends GenericParameter<Parameters>,
    LocationParameter<Parameters>,
    TimeParameter<Parameters>,
    Builder<MoonPosition> {
    }
}

