/*
 * Decompiled with CFR 0.152.
 */
package org.shredzone.acme4j.connector;

import java.io.IOException;
import java.io.InputStream;
import java.net.HttpURLConnection;
import java.net.Proxy;
import java.net.URL;
import java.util.Properties;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.ThreadSafe;
import org.slf4j.LoggerFactory;

@ParametersAreNonnullByDefault
@ThreadSafe
public class HttpConnector {
    private static final int TIMEOUT = 10000;
    private static final String USER_AGENT;

    public static String defaultUserAgent() {
        return USER_AGENT;
    }

    public HttpURLConnection openConnection(URL url, Proxy proxy) throws IOException {
        HttpURLConnection conn = (HttpURLConnection)url.openConnection(proxy);
        this.configure(conn);
        return conn;
    }

    protected void configure(HttpURLConnection conn) {
        conn.setConnectTimeout(10000);
        conn.setReadTimeout(10000);
        conn.setUseCaches(false);
        conn.setRequestProperty("User-Agent", USER_AGENT);
    }

    static {
        StringBuilder agent = new StringBuilder("acme4j");
        try (InputStream in = HttpConnector.class.getResourceAsStream("/org/shredzone/acme4j/version.properties");){
            Properties prop = new Properties();
            prop.load(in);
            agent.append('/').append(prop.getProperty("version"));
        }
        catch (Exception ex) {
            LoggerFactory.getLogger(HttpConnector.class).warn("Could not read library version", (Throwable)ex);
        }
        agent.append(" Java/").append(System.getProperty("java.version"));
        USER_AGENT = agent.toString();
    }
}

