/*
 * Decompiled with CFR 0.152.
 */
package org.shredzone.acme4j.provider;

import java.net.URI;
import java.time.ZonedDateTime;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.function.BiFunction;
import org.shredzone.acme4j.Login;
import org.shredzone.acme4j.Session;
import org.shredzone.acme4j.challenge.Challenge;
import org.shredzone.acme4j.challenge.Dns01Challenge;
import org.shredzone.acme4j.challenge.Http01Challenge;
import org.shredzone.acme4j.challenge.TlsAlpn01Challenge;
import org.shredzone.acme4j.challenge.TokenChallenge;
import org.shredzone.acme4j.connector.Connection;
import org.shredzone.acme4j.connector.DefaultConnection;
import org.shredzone.acme4j.connector.HttpConnector;
import org.shredzone.acme4j.exception.AcmeException;
import org.shredzone.acme4j.provider.AcmeProvider;
import org.shredzone.acme4j.toolbox.JSON;

public abstract class AbstractAcmeProvider
implements AcmeProvider {
    private static final Map<String, BiFunction<Login, JSON, Challenge>> CHALLENGES = AbstractAcmeProvider.challengeMap();

    @Override
    public Connection connect(URI serverUri) {
        return new DefaultConnection(this.createHttpConnector());
    }

    @Override
    public JSON directory(Session session, URI serverUri) throws AcmeException {
        ZonedDateTime expires = session.getDirectoryExpires();
        if (expires != null && expires.isAfter(ZonedDateTime.now())) {
            return null;
        }
        try (Connection conn = this.connect(serverUri);){
            ZonedDateTime lastModified = session.getDirectoryLastModified();
            int rc = conn.sendRequest(this.resolve(serverUri), session, lastModified);
            if (lastModified != null && rc == 304) {
                JSON jSON = null;
                return jSON;
            }
            session.setDirectoryLastModified(conn.getLastModified().orElse(null));
            session.setDirectoryExpires(conn.getExpiration().orElse(null));
            String nonce = conn.getNonce();
            if (nonce != null) {
                session.setNonce(nonce);
            }
            JSON jSON = conn.readJsonResponse();
            return jSON;
        }
    }

    private static Map<String, BiFunction<Login, JSON, Challenge>> challengeMap() {
        HashMap<String, BiFunction<Login, JSON, Challenge>> map = new HashMap<String, BiFunction<Login, JSON, Challenge>>();
        map.put("dns-01", Dns01Challenge::new);
        map.put("http-01", Http01Challenge::new);
        map.put("tls-alpn-01", TlsAlpn01Challenge::new);
        return Collections.unmodifiableMap(map);
    }

    @Override
    public Challenge createChallenge(Login login, JSON data) {
        Objects.requireNonNull(login, "login");
        Objects.requireNonNull(data, "data");
        String type = data.get("type").asString();
        BiFunction<Login, JSON, Challenge> constructor = CHALLENGES.get(type);
        if (constructor != null) {
            return constructor.apply(login, data);
        }
        if (data.contains("token")) {
            return new TokenChallenge(login, data);
        }
        return new Challenge(login, data);
    }

    protected HttpConnector createHttpConnector() {
        return new HttpConnector();
    }
}

