/*
 * Decompiled with CFR 0.152.
 */
package org.shredzone.acme4j.connector;

import java.io.IOException;
import java.io.InputStream;

public class TrimmingInputStream
extends InputStream {
    private final InputStream in;
    private boolean wasLineSeparator = true;

    public TrimmingInputStream(InputStream in) {
        this.in = in;
    }

    @Override
    public int read() throws IOException {
        int ch = this.in.read();
        if (this.wasLineSeparator) {
            while (TrimmingInputStream.isLineSeparator(ch)) {
                ch = this.in.read();
            }
        }
        this.wasLineSeparator = TrimmingInputStream.isLineSeparator(ch);
        if (ch == 13) {
            ch = 10;
        }
        return ch;
    }

    @Override
    public void close() throws IOException {
        this.in.close();
        super.close();
    }

    private static boolean isLineSeparator(int ch) {
        return ch == 10 || ch == 13;
    }
}

