/*
 * Decompiled with CFR 0.152.
 */
package org.shredzone.acme4j;

import edu.umd.cs.findbugs.annotations.Nullable;
import java.net.URI;
import java.net.URL;
import java.time.Duration;
import java.util.Collection;
import java.util.Optional;
import java.util.stream.Collectors;
import org.shredzone.acme4j.toolbox.JSON;

public class Metadata {
    private final JSON meta;

    public Metadata(JSON meta) {
        this.meta = meta;
    }

    @Nullable
    public URI getTermsOfService() {
        return this.meta.get("termsOfService").map(JSON.Value::asURI).orElse(null);
    }

    @Nullable
    public URL getWebsite() {
        return this.meta.get("website").map(JSON.Value::asURL).orElse(null);
    }

    public Collection<String> getCaaIdentities() {
        return this.meta.get("caaIdentities").asArray().stream().map(JSON.Value::asString).collect(Collectors.toList());
    }

    public boolean isExternalAccountRequired() {
        return this.meta.get("externalAccountRequired").map(JSON.Value::asBoolean).orElse(false);
    }

    public boolean isAutoRenewalEnabled() {
        return this.meta.get("auto-renewal").isPresent();
    }

    @Nullable
    public Duration getAutoRenewalMinLifetime() {
        Optional<JSON> ar = this.meta.get("auto-renewal").optional().map(JSON.Value::asObject);
        if (!ar.isPresent()) {
            return null;
        }
        return ar.get().get("min-lifetime").map(JSON.Value::asDuration).orElse(null);
    }

    @Nullable
    public Duration getAutoRenewalMaxDuration() {
        Optional<JSON> ar = this.meta.get("auto-renewal").optional().map(JSON.Value::asObject);
        if (!ar.isPresent()) {
            return null;
        }
        return ar.get().get("max-duration").map(JSON.Value::asDuration).orElse(null);
    }

    public boolean isAutoRenewalGetAllowed() {
        Optional<JSON> ar = this.meta.get("auto-renewal").optional().map(JSON.Value::asObject);
        if (!ar.isPresent()) {
            return false;
        }
        return ar.get().get("allow-certificate-get").map(JSON.Value::asBoolean).orElse(false);
    }

    public JSON getJSON() {
        return this.meta;
    }
}

