/*
 * Decompiled with CFR 0.152.
 */
package org.shredzone.acme4j;

import java.io.Serializable;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.Map;
import java.util.Objects;
import org.shredzone.acme4j.exception.AcmeProtocolException;
import org.shredzone.acme4j.toolbox.AcmeUtils;
import org.shredzone.acme4j.toolbox.JSON;
import org.shredzone.acme4j.toolbox.JSONBuilder;

public class Identifier
implements Serializable {
    private static final long serialVersionUID = -7777851842076362412L;
    public static final String TYPE_DNS = "dns";
    public static final String TYPE_IP = "ip";
    private static final String KEY_TYPE = "type";
    private static final String KEY_VALUE = "value";
    private final String type;
    private final String value;

    public Identifier(String type, String value) {
        this.type = Objects.requireNonNull(type, KEY_TYPE);
        this.value = Objects.requireNonNull(value, KEY_VALUE);
    }

    public Identifier(JSON json) {
        this(json.get(KEY_TYPE).asString(), json.get(KEY_VALUE).asString());
    }

    public static Identifier dns(String domain) {
        return new Identifier(TYPE_DNS, AcmeUtils.toAce(domain));
    }

    public static Identifier ip(InetAddress ip) {
        return new Identifier(TYPE_IP, ip.getHostAddress());
    }

    public static Identifier ip(String ip) {
        try {
            return Identifier.ip(InetAddress.getByName(ip));
        }
        catch (UnknownHostException ex) {
            throw new IllegalArgumentException("Bad IP: " + ip, ex);
        }
    }

    public String getType() {
        return this.type;
    }

    public String getValue() {
        return this.value;
    }

    public String getDomain() {
        if (!TYPE_DNS.equals(this.type)) {
            throw new AcmeProtocolException("expected 'dns' identifier, but found '" + this.type + "'");
        }
        return this.value;
    }

    public InetAddress getIP() {
        if (!TYPE_IP.equals(this.type)) {
            throw new AcmeProtocolException("expected 'ip' identifier, but found '" + this.type + "'");
        }
        try {
            return InetAddress.getByName(this.value);
        }
        catch (UnknownHostException ex) {
            throw new AcmeProtocolException("bad ip identifier value", ex);
        }
    }

    public Map<String, Object> toMap() {
        return new JSONBuilder().put(KEY_TYPE, this.type).put(KEY_VALUE, this.value).toMap();
    }

    public String toString() {
        return this.type + "=" + this.value;
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof Identifier)) {
            return false;
        }
        Identifier i = (Identifier)obj;
        return this.type.equals(i.type) && this.value.equals(i.value);
    }

    public int hashCode() {
        return this.type.hashCode() ^ this.value.hashCode();
    }
}

