/*
 * Decompiled with CFR 0.152.
 */
package org.seqdoop.hadoop_bam.util;

import htsjdk.samtools.seekablestream.SeekableStream;
import htsjdk.samtools.util.BlockCompressedInputStream;
import htsjdk.tribble.FeatureCodecHeader;
import htsjdk.tribble.TribbleException;
import htsjdk.tribble.readers.AsciiLineReader;
import htsjdk.tribble.readers.AsciiLineReaderIterator;
import htsjdk.tribble.readers.LineIterator;
import htsjdk.tribble.readers.PositionalBufferedStream;
import htsjdk.variant.bcf2.BCF2Codec;
import htsjdk.variant.vcf.VCFCodec;
import htsjdk.variant.vcf.VCFHeader;
import java.io.BufferedInputStream;
import java.io.IOException;
import java.io.InputStream;

public final class VCFHeaderReader {
    public static VCFHeader readHeaderFrom(SeekableStream in) throws IOException {
        FeatureCodecHeader headerCodec = null;
        Object header = null;
        long initialPos = in.position();
        try {
            headerCodec = new VCFCodec().readHeader((LineIterator)new AsciiLineReaderIterator(new AsciiLineReader((InputStream)in)));
        }
        catch (TribbleException e) {
            System.err.println("warning: while trying to read VCF header from file received exception: " + e.toString());
            in.seek(initialPos);
            BufferedInputStream bin = new BufferedInputStream((InputStream)in);
            if (BlockCompressedInputStream.isValidFile((InputStream)bin)) {
                bin = new BlockCompressedInputStream((InputStream)bin);
            }
            headerCodec = new BCF2Codec().readHeader(new PositionalBufferedStream((InputStream)bin));
        }
        if (!(headerCodec instanceof FeatureCodecHeader)) {
            throw new IOException("No VCF header found");
        }
        header = headerCodec.getHeaderValue();
        return (VCFHeader)header;
    }
}

