/*
 * Decompiled with CFR 0.152.
 */
package org.seqdoop.hadoop_bam.cli;

import java.io.PrintStream;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.ServiceConfigurationError;
import java.util.ServiceLoader;
import java.util.TreeMap;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.util.GenericOptionsParser;
import org.seqdoop.hadoop_bam.cli.CLIPlugin;
import org.seqdoop.hadoop_bam.cli.Utils;

public final class Frontend {
    public static final int VERSION_MAJOR = 7;
    public static final int VERSION_MINOR = 0;

    public static void main(String[] args) {
        GenericOptionsParser parser;
        Thread thread = Thread.currentThread();
        URLClassLoader loader2 = (URLClassLoader)thread.getContextClassLoader();
        try {
            parser = new GenericOptionsParser(args);
        }
        catch (Exception e) {
            System.err.printf("Error in Hadoop arguments: %s\n", e.getMessage());
            System.exit(1);
            return;
        }
        args = parser.getRemainingArgs();
        Configuration conf = parser.getConfiguration();
        URLClassLoader loader1 = (URLClassLoader)thread.getContextClassLoader();
        if (loader1 != loader2) {
            URL[] urls1 = loader1.getURLs();
            URL[] urls2 = loader2.getURLs();
            URL[] allURLs = new URL[urls1.length + urls2.length];
            System.arraycopy(urls1, 0, allURLs, 0, urls1.length);
            System.arraycopy(urls2, 0, allURLs, urls1.length, urls2.length);
            thread.setContextClassLoader(new URLClassLoader(allURLs, loader2.getParent()));
            conf.setClassLoader(thread.getContextClassLoader());
        }
        try {
            Class<?> frontendClass = Class.forName(Frontend.class.getName(), true, thread.getContextClassLoader());
            Method meth = frontendClass.getMethod("go", args.getClass(), conf.getClass());
            meth.invoke(null, args, conf);
        }
        catch (InvocationTargetException e) {
            e.getCause().printStackTrace();
            System.exit(1);
        }
        catch (ClassNotFoundException e) {
            System.err.println("VERY STRANGE: could not reload Frontend class:");
            e.printStackTrace();
        }
        catch (NoSuchMethodException e) {
            System.err.println("VERY STRANGE: could not find our own method:");
            e.printStackTrace();
        }
        catch (IllegalAccessException e) {
            System.err.println("VERY STRANGE: not allowed to access our own method:");
            e.printStackTrace();
        }
        System.exit(112);
    }

    public static void go(String[] args, Configuration conf) {
        String command;
        CLIPlugin p;
        TreeMap<String, CLIPlugin> plugins = new TreeMap<String, CLIPlugin>();
        ServiceLoader<CLIPlugin> pluginLoader = ServiceLoader.load(CLIPlugin.class);
        HashSet<String> seenServiceConfigErrors = new HashSet<String>(0);
        Iterator<CLIPlugin> it = pluginLoader.iterator();
        while (true) {
            try {
                if (!it.hasNext()) break;
                p = it.next();
            }
            catch (ServiceConfigurationError e) {
                String msg;
                if (seenServiceConfigErrors.isEmpty()) {
                    System.err.println("Warning: ServiceConfigurationErrors while loading plugins:");
                }
                if (seenServiceConfigErrors.contains(msg = e.getMessage())) continue;
                System.err.println(msg);
                seenServiceConfigErrors.add(msg);
                continue;
            }
            plugins.put(p.getCommandName(), p);
        }
        if (plugins.isEmpty()) {
            System.err.println("Error: no CLI plugins found: no functionality available");
            System.exit(1);
        }
        Utils.setArgv0Class(Frontend.class);
        if (args.length == 0) {
            Frontend.usage(System.err, plugins);
            System.exit(1);
        }
        if ((command = args[0]).equals("--help")) {
            Frontend.usage(System.out, plugins);
            System.exit(0);
        }
        if ((p = (CLIPlugin)((Object)plugins.get(command))) == null) {
            System.err.printf("Unknown command '%s', see '--help' for help.\n", command);
            System.exit(1);
        }
        p.setConf(conf);
        System.exit(p.main(Arrays.asList(args).subList(1, args.length)));
    }

    public static void usage(PrintStream out, Map<String, CLIPlugin> plugins) {
        out.printf("hadoop-bam version %d.%d command line frontend\n", 7, 0);
        out.printf("Usage: %s <command> [options]\n", Utils.getArgv0());
        int cmdLen = 0;
        for (String cmd : plugins.keySet()) {
            cmdLen = Math.max(cmdLen, cmd.length());
        }
        String cmdFmt = "%-" + cmdLen + "s  ";
        out.print("\nCommand: ");
        int cmdPos = "Command: ".length();
        int descPos = cmdPos + cmdLen + 2;
        boolean first = true;
        for (Map.Entry<String, CLIPlugin> entry : plugins.entrySet()) {
            if (first) {
                first = false;
            } else {
                int i = cmdPos;
                while (i-- > 0) {
                    out.print(' ');
                }
            }
            out.printf(cmdFmt, entry.getKey());
            Utils.printWrapped(out, entry.getValue().getDescription(), descPos);
        }
    }
}

