/*
 * Decompiled with CFR 0.152.
 */
package org.seqdoop.hadoop_bam;

import htsjdk.samtools.util.BlockCompressedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.LongBuffer;
import java.util.Arrays;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;

public final class SplittingBAMIndexer {
    private static final String OUTPUT_FILE_EXTENSION = ".splitting-bai";
    private final ByteBuffer byteBuffer;
    private final int granularity;
    private static final int PRINT_EVERY = 524288000;

    public static void main(String[] args) {
        int granularity;
        if (args.length <= 1) {
            System.out.println("Usage: SplittingBAMIndexer GRANULARITY [BAM files...]\n\nWrites, for each GRANULARITY alignments in a BAM file, its virtual file offset\nas a big-endian 64-bit integer into [filename].splitting-bai. The file is\nterminated by the BAM file's length, in the same format.");
            return;
        }
        try {
            granularity = Integer.parseInt(args[0]);
        }
        catch (NumberFormatException e) {
            granularity = 0;
        }
        if (granularity <= 0) {
            System.err.printf("Granularity must be a positive integer, not '%s'!\n", args[0]);
            return;
        }
        SplittingBAMIndexer indexer = new SplittingBAMIndexer(granularity);
        for (String arg : Arrays.asList(args).subList(1, args.length)) {
            File f = new File(arg);
            System.out.printf("Indexing %s...", f);
            try {
                indexer.index(new FileInputStream(f), new BufferedOutputStream(new FileOutputStream(f + OUTPUT_FILE_EXTENSION)), f.length());
                System.out.println(" done.");
            }
            catch (IOException e) {
                System.out.println(" FAILED!");
                e.printStackTrace();
            }
        }
    }

    public static void run(Configuration conf) throws IOException {
        String inputString = conf.get("input");
        if (inputString == null) {
            throw new IllegalArgumentException("String property \"input\" path not found in given Configuration");
        }
        FileSystem fs = FileSystem.get((Configuration)conf);
        SplittingBAMIndexer indexer = new SplittingBAMIndexer(conf.getInt("granularity", 4096));
        Path input = new Path(inputString);
        indexer.index((InputStream)fs.open(input), (OutputStream)fs.create(input.suffix(OUTPUT_FILE_EXTENSION)), fs.getFileStatus(input).getLen());
    }

    public SplittingBAMIndexer(int g) {
        this.granularity = g;
        this.byteBuffer = ByteBuffer.allocate(8);
    }

    private void index(InputStream rawIn, OutputStream out, long inputSize) throws IOException {
        PtrSkipPair pair;
        BlockCompressedInputStream in = new BlockCompressedInputStream(rawIn);
        LongBuffer lb = this.byteBuffer.order(ByteOrder.BIG_ENDIAN).asLongBuffer();
        this.skipToAlignmentList((InputStream)in);
        lb.put(0, in.getFilePointer());
        out.write(this.byteBuffer.array());
        long prevPrint = in.getFilePointer() >> 16;
        int i = 0;
        while ((pair = this.readAlignment(in)) != null) {
            if (++i == this.granularity) {
                i = 0;
                lb.put(0, pair.ptr);
                out.write(this.byteBuffer.array());
                long filePos = pair.ptr >> 16;
                if (filePos - prevPrint >= 524288000L) {
                    System.out.print("-");
                    prevPrint = filePos;
                }
            }
            this.fullySkip((InputStream)in, pair.skip);
        }
        lb.put(0, inputSize << 16);
        out.write(this.byteBuffer.array());
        out.close();
        in.close();
    }

    private void skipToAlignmentList(InputStream in) throws IOException {
        int magic;
        if (!this.readExactlyBytes(in, 4)) {
            this.ioError("Invalid BAM header: too short, no magic", new Object[0]);
        }
        if ((magic = this.byteBuffer.order(ByteOrder.BIG_ENDIAN).getInt(0)) != 1111575809) {
            this.ioError("Invalid BAM header: bad magic %#x != 0x42414d01", magic);
        }
        if (!this.readExactlyBytes(in, 4)) {
            this.ioError("Invalid BAM header: too short, no SAM header length", new Object[0]);
        }
        this.byteBuffer.order(ByteOrder.LITTLE_ENDIAN);
        int samLen = this.byteBuffer.getInt(0);
        if (samLen < 0) {
            this.ioError("Invalid BAM header: negative SAM header length %d", samLen);
        }
        this.fullySkip(in, samLen);
        if (!this.readExactlyBytes(in, 4)) {
            this.ioError("Invalid BAM header: too short, no reference sequence count", new Object[0]);
        }
        int referenceSeqs = this.byteBuffer.getInt(0);
        for (int s = 0; s < referenceSeqs; ++s) {
            if (!this.readExactlyBytes(in, 4)) {
                this.ioError("Invalid reference list: EOF before reference %d", s + 1);
            }
            this.fullySkip(in, this.byteBuffer.getInt(0) + 4);
        }
    }

    private PtrSkipPair readAlignment(BlockCompressedInputStream in) throws IOException {
        long ptr = in.getFilePointer();
        int read = this.readBytes((InputStream)in, 4);
        if (read != 4) {
            if (read == 0) {
                return null;
            }
            this.ioError("Invalid alignment at virtual offset %#x: less than 4 bytes long", in.getFilePointer());
        }
        return new PtrSkipPair(ptr, this.byteBuffer.getInt(0));
    }

    private void fullySkip(InputStream in, int skip) throws IOException {
        int s = skip;
        while (s > 0) {
            long skipped = in.skip(s);
            if (skipped == 0L) {
                throw new IOException("Skip failed");
            }
            s = (int)((long)s - skipped);
        }
    }

    private int readBytes(InputStream in, int n) throws IOException {
        int read;
        int readNow;
        assert (n <= this.byteBuffer.capacity());
        for (read = 0; read < n && (readNow = in.read(this.byteBuffer.array(), read, n - read)) > 0; read += readNow) {
        }
        return read;
    }

    private boolean readExactlyBytes(InputStream in, int n) throws IOException {
        return this.readBytes(in, n) == n;
    }

    private void ioError(String s, Object ... va) throws IOException {
        throw new IOException(String.format(s, va));
    }

    private static final class PtrSkipPair {
        public long ptr;
        public int skip;

        public PtrSkipPair(long p, int s) {
            this.ptr = p;
            this.skip = s;
        }
    }
}

