/*
 * Decompiled with CFR 0.152.
 */
package org.semver.enforcer;

import org.apache.maven.enforcer.rule.api.EnforcerRuleException;
import org.apache.maven.enforcer.rule.api.EnforcerRuleHelper;
import org.semver.Delta;
import org.semver.Version;
import org.semver.enforcer.AbstractEnforcerRule;

public final class RequireBackwardCompatibility
extends AbstractEnforcerRule {
    private String compatibilityType;
    private boolean strictChecking = false;

    @Override
    protected void enforce(EnforcerRuleHelper helper, Delta delta, Version previous, Version current) throws EnforcerRuleException {
        Delta.CompatibilityType expectedCompatibilityType;
        if (this.compatibilityType == null) {
            throw new IllegalArgumentException("A value for compatibilityType attribute must be provided.");
        }
        try {
            expectedCompatibilityType = Delta.CompatibilityType.valueOf((String)this.compatibilityType);
        }
        catch (IllegalStateException e) {
            throw new EnforcerRuleException("Compatibility type value must be one of " + Delta.CompatibilityType.values());
        }
        Delta.CompatibilityType detectedCompatibilityType = delta.computeCompatibilityType();
        if (this.strictChecking) {
            if (detectedCompatibilityType != expectedCompatibilityType) {
                this.fail(delta, "Current codebase is not strictly backward compatible (" + this.compatibilityType + ") with version <" + previous + ">. Compatibility type has been detected as <" + detectedCompatibilityType + ">");
            }
        } else {
            if (expectedCompatibilityType == Delta.CompatibilityType.NON_BACKWARD_COMPATIBLE) {
                helper.getLog().warn((CharSequence)("Rule will never fail as compatibility type " + Delta.CompatibilityType.NON_BACKWARD_COMPATIBLE + " is used with non-strict checking."));
            }
            if (detectedCompatibilityType.compareTo((Enum)expectedCompatibilityType) > 0) {
                this.fail(delta, "Current codebase is not backward compatible (" + this.compatibilityType + ") with version <" + previous + ">. Compatibility type has been detected as <" + detectedCompatibilityType + ">");
            }
        }
    }
}

