module.exports = {
    name: 'Waterfall',
    icon: require('images/waterfall.svg'),
    widgetList: {
        tags: ['Visualization'],
        showOn: 'none',
        quickMenu: [
            'events',
            'unfilter',
            'color-by-value',
            'flip-axis',
            'toggle-zoom-x',
            'toggle-zoom-y',
            'reverse-y',
            'infinite-viz',
        ],
    },
    content: {
        template: {
            name: 'waterfall-echarts',
        },
    },
    visualization: {
        type: ['echarts'],
        group: 'Visualization',
        view: 'visualization',
        layout: 'Waterfall',
        visibleModes: ['default-mode', 'comment-mode', 'polygon-brush-mode'],
        tools: [
            'custom-legend',
            'filter',
            'unfilter',
            'sort-values',
            'flip-axis',
            'edit-x-axis',
            'edit-y-axis',
            'reverse-y',
            'edit-grid',
            'display-values',
            'format-data-values',
            'toggle-zoom-x',
            'toggle-zoom-y',
            'color-scheme',
            'color-by-value',
            'customize-bar-label',
            'toggle-tooltips',
            'reset-state',
            'events',
            'param',
            'purge',
            'refresh-cache',
        ],
        showOnVisualPanel: true,
        visualPanelMenu: {
            USE: 'Pipeline',
        },
        format: 'table',
        fields: [
            {
                model: 'label',
                name: 'X-Axis',
                acceptableTypes: ['STRING', 'NUMBER', 'DATE'],
                group: 'validate',
                optional: false,
                multiField: false,
                description:
                    'Try adding one categorical dimension (i.e. Movie Genre). Each instance within this dimension will appear on the x-axis.',
            },
            {
                model: 'start',
                name: 'Start',
                acceptableTypes: ['NUMBER'],
                group: 'math',
                optional: false,
                multiField: false,
                description:
                    'Try adding one or several dimensions (i.e. Movie Budget). The numerical values of these dimensions will represent their respective column size.',
            },
            {
                model: 'end',
                name: 'End',
                acceptableTypes: ['NUMBER'],
                group: 'math',
                optional: false,
                multiField: false,
                description:
                    'Try adding one or several dimensions (i.e. Movie Budget). The numerical values of these dimensions will represent their respective column size.',
            },
            {
                model: 'tooltip',
                name: 'Tooltip',
                acceptableTypes: ['STRING', 'NUMBER', 'DATE'],
                group: 'math',
                optional: true,
                multiField: true,
                description:
                    'Try adding one or several dimensions (i.e. Movie Revenue). Each instance of this dimension will appear in the tooltip when hovering.',
            },
            {
                model: 'facet',
                name: 'Facet',
                acceptableTypes: ['STRING', 'DATE'],
                group: 'validate',
                optional: true,
                multiField: false,
                description:
                    'Try adding one dimension (i.e. Nominated). The data will be grouped by each instance of the selected dimension.',
            },
        ],
        color: {
            value: {
                multiField: true,
                instances: false,
            },
        },
    },
    lazy: true,
};
