module.exports = {
    name: 'Pie',
    icon: require('images/pie.svg'),
    widgetList: {
        tags: ['Visualization'],
        showOn: 'none',
        quickMenu: [
            'events',
            'unfilter',
            'color-panel-mode',
            'color-by-value',
            'rose-mode',
            'infinite-viz',
        ],
    },
    content: {
        template: {
            name: 'pie-echarts',
        },
    },
    visualization: {
        type: ['echarts'],
        group: 'Visualization',
        view: 'visualization',
        layout: 'Pie',
        visibleModes: ['default-mode', 'comment-mode'],
        tools: [
            'legend-viz',
            'custom-legend',
            'filter',
            'unfilter',
            'color-panel',
            //'toggle-legend',
            'toggle-tooltips',
            'display-values',
            'format-data-values',
            'customize-pie-label',
            'rose',
            'pie-radius',
            'animation-pie',
            'toggle-shadow',
            'toggle-donut',
            'bucket',
            'color-by-value',
            'facet-headers',
            'reset-state',
            'events',
            'purge',
            'refresh-cache',
            'chart-title',
        ],
        showOnVisualPanel: true,
        visualPanelMenu: {
            USE: 'Part-to-whole',
        },
        format: 'table',
        fields: [
            {
                model: 'label',
                name: 'Label',
                acceptableTypes: ['STRING', 'NUMBER', 'DATE'],
                group: 'validate',
                optional: false,
                multiField: false,
                description:
                    'Try adding one categorical dimension (i.e. Movie Genre). Each instance within this dimension will represent a pie slice.',
            },
            {
                model: 'value',
                name: 'Value',
                acceptableTypes: ['NUMBER'],
                group: 'math',
                optional: false,
                multiField: false,
                description:
                    'Try adding one dimension (i.e. Movie Budget). The numerical value of this dimension will represent the size of its respective pie slice.',
            },
            {
                model: 'heat',
                name: 'Heat',
                acceptableTypes: ['NUMBER'],
                group: 'math',
                optional: true,
                multiField: false,
                description:
                    'Try adding one dimension (i.e. Movie Rating). The numerical value of this dimension will represent the heat color of its respective pie slice',
            },
            {
                model: 'tooltip',
                name: 'Tooltip',
                acceptableTypes: ['STRING', 'NUMBER', 'DATE'],
                group: 'math',
                optional: true,
                multiField: true,
                description:
                    'Try adding one or several dimensions (i.e. Director). Each instance of this dimension will appear in the tooltip when hovering.',
            },
            {
                model: 'facet',
                name: 'Facet',
                acceptableTypes: ['STRING', 'DATE'],
                group: 'validate',
                optional: true,
                multiField: false,
                description:
                    'Try adding one dimension (i.e. Nominated). The data will be grouped by each instance of the selected dimension.',
            },
        ],
        color: {
            label: {
                multiField: true,
                instances: true,
            },
        },
    },
    lazy: true,
};
