/**
 * Search the option and see if the string matches the option
 * @param search - search string
 * @param option - option that we are searching
 * @returns true if found
 */
export function getSearch<O>(search: string, option: O): boolean {
    // convert to string
    let str = '';

    if (typeof option === 'object') {
        str = JSON.stringify(option);
    } else {
        str = String(option);
    }

    return str.toLowerCase().includes(search);
}
