import { ReactNode } from 'react';

export function getDisplay<O>(option: O): ReactNode {
    if (typeof option === 'number' && isNaN(option)) {
        return <>&nbsp;</>;
    }

    if (typeof option === 'string' && !option.trim()) {
        return <>&nbsp;</>;
    }

    if (typeof option === 'object') {
        return <>{JSON.stringify(option)}</>;
    }

    return <>{option}</>;
}
