import * as Stitches from '@stitches/react';
import { createStitches } from '@stitches/react';

const stitches = createStitches({
    prefix: 'smss',
    media: {
        sm: '(min-width: 640px)',
        md: '(min-width: 768px)',
        lg: '(min-width: 1024px)',
        xl: '(min-width: 1280px)',
        xxl: '(min-width: 1536px)',
    },
    theme: {
        borderWidths: {
            none: '0',
            default: '1px',
            thick: '2px',
            thicker: '4px',
        },
        radii: {
            none: '0',
            default: '0.25rem',
            full: '9999px',
        },
        colors: {
            base: '#FFFFFF',
            'transparent-dark-1': 'rgba(0, 0, 0, 1)',
            'transparent-dark-2': 'rgba(0, 0, 0, .7)',
            'transparent-dark-3': 'rgba(0, 0, 0, .5)',
            'transparent-dark-4': 'rgba(0, 0, 0, .3)',
            'transparent-dark-5': 'rgba(0, 0, 0, .1)',
            'transparent-light-1': 'rgba(255, 255, 255, 1)',
            'transparent-light-2': 'rgba(255, 255, 255, .7)',
            'transparent-light-3': 'rgba(255, 255, 255, .5)',
            'transparent-light-4': 'rgba(255, 255, 255, .3)',
            'transparent-light-5': 'rgba(255, 255, 255, .1)',
            'grey-1': '#5C5C5C',
            'grey-2': '#8E8E8E',
            'grey-3': '#BDBDBD',
            'grey-4': '#D9D9D9',
            'grey-5': '#F8F8F8',
            'primary-1': '#40A0FF',
            'primary-2': '#79BDFF',
            'primary-3': '#9FCFFF',
            'primary-4': '#C6E3FF',
            'primary-5': '#ECF6FF',
            'success-1': '#3FA875',
            'success-2': '#78C29E',
            'success-3': '#9FD3BA',
            'success-4': '#C5E5D5',
            'success-5': '#ECF6F1',
            'warning-1': '#FA9F2C',
            'warning-2': '#FFBC6B',
            'warning-3': '#FFCF95',
            'warning-4': '#FFE2BF',
            'warning-5': '#FFF5EA',
            'error-1': '#F84C34',
            'error-2': '#FA8171',
            'error-3': '#FBA599',
            'error-4': '#FDC9C2',
            'error-5': '#FEEDEB',
        },
        fontSizes: {
            default: '1rem',
            xs: '0.75rem',
            sm: '0.875rem',
            md: '1rem',
            lg: '1.125rem',
            xl: '1.25rem',
            xxl: '1.5rem',
        },
        fontWeights: {
            hairline: '100',
            thin: '200',
            light: '300',
            default: '400',
            medium: '500',
            semibold: '600',
            bold: '700',
            extrabold: '800',
            black: '900',
        },
        lineHeights: {
            none: '1',
            default: '1.5',
        },
        shadows: {
            none: 'none',
            default:
                '0 4px 6px -1px rgba(0, 0, 0, 0.1), 0 2px 4px -1px rgba(0, 0, 0, 0.06)',
        },
        sizes: {},
        space: {
            auto: 'auto',
            full: '100%',
            none: '0',
            0: '0',
            '-1': '-0.25rem',
            '-2': '-0.5rem',
            '-3': '-0.75rem',
            '-4': '-1rem',
            '-5': '-1.25rem',
            '-6': '-1.5rem',
            '-8': '-2rem',
            '-10': '-2.5rem',
            '-12': '-3rem',
            '-16': '-4rem',
            '-20': '-5rem',
            '-24': '-6rem',
            '-32': '-8rem',
            '-40': '-10rem',
            '-48': '-12rem',
            '-56': '-14rem',
            '-64': '-16rem',
            '-68': '-17rem',
            '-72': '-18rem',
            '-80': '-20rem',
            '-96': '-24rem',
            '1': '0.25rem',
            '2': '0.5rem',
            '3': '0.75rem',
            '4': '1rem',
            '5': '1.25rem',
            '6': '1.5rem',
            '8': '2rem',
            '10': '2.5rem',
            '12': '3rem',
            '16': '4rem',
            '20': '5rem',
            '24': '6rem',
            '32': '8rem',
            '40': '10rem',
            '48': '12rem',
            '56': '14rem',
            '64': '16rem',
            '68': '17rem',
            '72': '18rem',
            '80': '20rem',
            '96': '24rem',
        },
    },
});

export const {
    styled,
    css,
    createTheme,
    globalCss,
    theme,
    config,
    keyframes,
    getCssText,
} = stitches;

/**Based on Tailwind's Preflight https://unpkg.com/tailwindcss@3.0.23/src/css/preflight.css **/
const reset = {
    '*': {
        boxSizing: 'border-box',
        borderWidth: '0',
        borderStyle: 'solid',
        borderColor: `#000000`,
    },
    ':focus': {
        outline: 'none',
    },
    ':focus-visible': {
        outline: '2px solid $primary-1',
        outlineOffset: '2px',
    },
    '::before': {
        boxSizing: 'border-box',
        borderWidth: '0',
        borderStyle: 'solid',
    },
    '::after': {
        boxSizing: 'border-box',
        borderWidth: '0',
        borderStyle: 'solid',
    },
    '::placeholder': {
        color: `$grey-3`,
    },
    html: {
        lineHeight: '$default',
        WebkitTextSizeAdjust: '100%',
        MozTabSize: '4',
        tabSize: '4',
        fontFamily:
            'ui-sans-serif, system-ui, -apple-system, BlinkMacSystemFont, "Segoe UI", Roboto, "Helvetica Neue", Arial, "Noto Sans", sans-serif, "Apple Color Emoji", "Segoe UI Emoji", "Segoe UI Symbol", "Noto Color Emoji"',
    },
    body: {
        margin: '0',
        lineHeight: 'inherit',
        color: '$grey-1',
    },
    hr: {
        margin: '0',
        color: 'inherit',
        borderTopWidth: '1px',
    },
    'abbr:where([title])': {
        textDecoration: 'underline dotted',
    },
    h1: {
        margin: '0',
        fontSize: 'inherit',
        fontWeight: 'inherit',
    },
    h2: {
        margin: '0',
        fontSize: 'inherit',
        fontWeight: 'inherit',
    },
    h3: {
        margin: '0',
        fontSize: 'inherit',
        fontWeight: 'inherit',
    },
    h4: {
        margin: '0',
        fontSize: 'inherit',
        fontWeight: 'inherit',
    },
    h5: {
        margin: '0',
        fontSize: 'inherit',
        fontWeight: 'inherit',
    },
    h6: {
        margin: '0',
        fontSize: 'inherit',
        fontWeight: 'inherit',
    },
    // htmlString can't get overwritten
    // a: {
    //     color: 'inherit',
    //     textDecoration: 'inherit',
    // },
    b: {
        fontWeight: 'bolder',
    },
    strong: {
        fontWeight: 'bolder',
    },
    code: {
        fontFamily:
            'ui-monospace, SFMono-Regular, Menlo, Monaco, Consolas, "Liberation Mono", "Courier New", monospace',
        fontSize: '1em',
    },
    kbd: {
        fontFamily:
            'ui-monospace, SFMono-Regular, Menlo, Monaco, Consolas, "Liberation Mono", "Courier New", monospace',
        fontSize: '1em',
    },
    samp: {
        fontFamily:
            'ui-monospace, SFMono-Regular, Menlo, Monaco, Consolas, "Liberation Mono", "Courier New", monospace',
        fontSize: '1em',
    },
    pre: {
        margin: '0',
        fontFamily:
            'ui-monospace, SFMono-Regular, Menlo, Monaco, Consolas, "Liberation Mono", "Courier New", monospace',
        fontSize: '1em',
    },
    small: {
        fontSize: '80%',
    },
    sub: {
        fontSize: '75%',
        lineHeight: '0',
        position: 'relative',
        verticalAlign: 'baseline',
        bottom: '-0.25em',
    },
    sup: {
        fontSize: '75%',
        lineHeight: '0',
        position: 'relative',
        verticalAlign: 'baseline',
        top: '-0.5em',
    },
    table: {
        textIndent: '0',
        borderColor: 'inherit',
        borderCollapse: 'collapse',
    },
    button: {
        backgroundColor: 'transparent',
        backgroundImage: 'none',
        cursor: 'pointer',
        fontFamily: 'inherit',
        fontSize: '100%',
        lineHeight: 'inherit',
        color: 'inherit',
        margin: '0',
        padding: '0',
        WebkitAppearance: 'button',
    },
    input: {
        fontFamily: 'inherit',
        fontSize: '100%',
        lineHeight: 'inherit',
        color: 'inherit',
        margin: '0',
        padding: '0',
    },
    optgroup: {
        fontFamily: 'inherit',
        fontSize: '100%',
        lineHeight: 'inherit',
        color: 'inherit',
        margin: '0',
        padding: '0',
    },
    select: {
        fontFamily: 'inherit',
        fontSize: '100%',
        lineHeight: 'inherit',
        color: 'inherit',
        margin: '0',
        padding: '0',
        textTransform: 'none',
    },
    textarea: {
        fontFamily: 'inherit',
        fontSize: '100%',
        lineHeight: 'inherit',
        color: 'inherit',
        margin: '0',
        padding: '0',
        resize: 'vertical',
    },
    "[type='button']": {
        WebkitAppearance: 'button',
        backgroundColor: 'transparent',
        backgroundImage: 'none',
    },
    "[type='reset']": {
        WebkitAppearance: 'button',
        backgroundColor: 'transparent',
        backgroundImage: 'none',
    },
    "[type='submit']": {
        WebkitAppearance: 'button',
        backgroundColor: 'transparent',
        backgroundImage: 'none',
    },
    ':-moz-focusring': {
        outline: 'auto',
    },
    ':-moz-ui-invalid': {
        boxShadow: 'none',
    },
    progress: {
        verticalAlign: 'baseline',
    },
    '::-webkit-inner-spin-button': {
        height: 'auto',
    },
    '::-webkit-outer-spin-button': {
        height: 'auto',
    },
    "[type='search']": {
        WebkitAppearance: 'textfield',
        outlineOffset: '-2px',
    },
    '::-webkit-search-decoration': {
        WebkitAppearance: 'none',
    },
    '::-webkit_file_upload_button': {
        WebkitAppearance: 'button',
        font: 'inherit',
    },
    summary: {
        display: 'list-item',
    },
    blockquote: {
        margin: '0',
    },
    dl: {
        margin: '0',
    },
    dd: {
        margin: '0',
    },
    figure: {
        margin: '0',
    },
    p: {
        margin: '0',
    },
    fieldset: {
        margin: '0',
        padding: '0',
    },
    legend: {
        padding: '0',
    },
    ol: {
        listStyle: 'none',
        margin: '0',
        padding: '0',
    },
    ul: {
        listStyle: 'none',
        margin: '0',
        padding: '0',
    },
    menu: {
        listStyle: 'none',
        margin: '0',
        padding: '0',
    },
    'input::placeholder': {
        opacity: '1',
    },
    'textarea::placeholder': {
        opacity: '1',
    },
    "[role='button']": {
        cursor: 'pointer',
    },
    ':disabled': {
        cursor: 'default',
    },
    img: {
        maxWidth: '100%',
        height: 'auto',
    },
    svg: {
        display: 'block',
        verticalAlign: 'middle',
    },
    video: {
        maxWidth: '100%',
        height: 'auto',
    },
    canvas: {
        display: 'block',
        verticalAlign: 'middle',
    },
    audio: {
        display: 'block',
        verticalAlign: 'middle',
    },
    iframe: {
        display: 'block',
        verticalAlign: 'middle',
    },
    embed: {
        display: 'block',
        verticalAlign: 'middle',
    },
    object: {
        display: 'block',
        verticalAlign: 'middle',
    },
    '[hidden]': {
        display: 'none',
    },
};

export const globalStyles = globalCss(reset);

// types
export type StitchesCSS = Stitches.CSS<typeof config>;
