import { useRef } from 'react';

let counter = 0;

/**
 * Generate a new id
 */
const generateId = () => {
    // increment
    counter++;

    // return the id
    return `semoss-${counter}`;
};

/**
 * Generate a unique id
 * @param id - optional user id to use
 * @returns a unique id for an element
 */
export function useId(id?: string): string {
    const idRef = useRef<string>();
    if (idRef.current === undefined || (id && idRef.current === id)) {
        idRef.current = id || generateId();
    }

    return idRef.current;
}
