import { styled } from '../../stitches.config';

export const BaseList = styled('ul', {
    backgroundColor: `$base`,
    borderWidth: '$default',
    borderRadius: '$default',
    boxShadow: 'none',
    display: 'inline-block',
    color: `$grey-1`,
    fontSize: '$sm',
    height: '$space$full',
    lineHeight: '$none',
    margin: '0',
    outline: 'none',
    padding: '$1',
    userSelect: 'none',
    overflowX: 'hidden',
    overflowY: 'auto',
    width: '$space$full',
});

export const BaseListOption = styled('li', {
    alignItems: 'center',
    backgroundColor: `$base`,
    borderRadius: '$default',
    boxShadow: 'none',
    cursor: 'pointer',
    display: 'flex',
    flex: '1 1 0',
    color: `$grey-1`,
    fontSize: '$sm',
    margin: '0',
    minHeight: '$space$8',
    padding: '0 $2',
    outline: 'none',
    overflow: 'hidden',
    width: '$space$full',
    '&[data-focused]': {
        backgroundColor: '$primary-5',
    },
});

// eslint-disable-next-line @typescript-eslint/no-empty-interface
export interface BaseListEmptyOptionProps {}

export const BaseListEmptyOption = styled('li', {
    alignItems: 'center',
    backgroundColor: `$base`,
    boxShadow: 'none',
    display: 'flex',
    color: `$grey-1`,
    fontSize: '$sm',
    height: '$space$8',
    justifyContent: 'center',
    margin: '0',
    padding: '0',
    position: 'relative',
    outline: 'none',
    overflow: 'hidden',
    width: '$space$full',
});
