import { ComponentProps, useState, useEffect } from 'react';
import { Story } from '@storybook/react';
import { Textarea } from './';

export default {
    title: 'Components/Textarea',
    component: Textarea,
    argTypes: {
        disabled: {
            type: { name: 'boolean', required: false },
            table: {
                defaultValue: { summary: 'false' },
            },
        },
        placeholder: {
            type: { name: 'string', required: false },
        },
        valid: {
            type: { name: 'boolean', required: false },
            table: {
                defaultValue: { summary: 'true' },
            },
        },
    },
};

/* Stories */

const Template: Story<ComponentProps<typeof Textarea>> = (args) => {
    const { value, onChange, ...otherArgs } = args;

    const [activeValue, setActiveValue] = useState(value);

    useEffect(() => {
        setActiveValue(value);
    }, [value]);

    return (
        <Textarea
            value={activeValue}
            onChange={(value) => {
                setActiveValue(value);
                onChange(value);
            }}
            {...otherArgs}
        />
    );
};

const MultiSizeTemplate: Story<ComponentProps<typeof Textarea>> = (args) => (
    <>
        <div
            style={{ display: 'flex', flexDirection: 'column', gap: '0.5rem' }}
        >
            <Textarea size="sm" {...args} />
            <Textarea size="md" {...args} />
            <Textarea size="lg" {...args} />
        </div>
    </>
);

// Default
export const Default = Template.bind({});

Default.args = {
    value: '',
    placeholder: undefined,
    disabled: false,
    valid: true,
};

// Placeholder
export const Placeholder = Template.bind({});

Placeholder.args = {
    ...Default.args,
    placeholder: 'Enter your name',
};

// Disabled
export const Disabled = Template.bind({});

Disabled.args = {
    ...Placeholder.args,
    disabled: true,
};

// Error
export const Error = Template.bind({});

Error.args = {
    ...Placeholder.args,
    valid: false,
};

// size
export const Size = MultiSizeTemplate.bind({});

Size.args = {
    ...Placeholder.args,
};

Size.argTypes = {
    size: {
        control: false,
    },
};
