import { ComponentPropsWithRef, forwardRef, ForwardedRef } from 'react';
import { TabsList as RadixTabsList } from '@radix-ui/react-tabs';

import { styled, theme } from '../../stitches.config';

const StyledTabsList = styled(RadixTabsList, {
    display: 'flex',
    borderBottomWidth: theme.borderWidths.thick,
    borderBottomColor: theme.colors['grey-4'],
});

export interface TabsListProps extends ComponentPropsWithRef<'div'> {
    /** Allow the items to loop through the list */
    loop?: boolean;
}

const _TabsList = (
    props: TabsListProps,
    ref: ForwardedRef<HTMLDivElement>,
): JSX.Element => {
    const { loop = true, children, ...otherProps } = props;
    return (
        <StyledTabsList ref={ref} loop={loop} {...otherProps}>
            {children}
        </StyledTabsList>
    );
};

export const TabsList = forwardRef(_TabsList) as (
    props: TabsListProps & {
        ref?: ForwardedRef<HTMLDivElement>;
    },
) => ReturnType<typeof _TabsList>;
