import { Table, TableProps } from './Table';
import { TableBody, TableBodyProps } from './TableBody';
import { TableCell, TableCellProps } from './TableCell';
import { TableHead, TableHeadProps } from './TableHead';
import { TableRow, TableRowProps } from './TableRow';

const TableNameSpace = Object.assign(Table, {
    Body: TableBody,
    Cell: TableCell,
    Head: TableHead,
    Row: TableRow,
});

export type {
    TableProps,
    TableBodyProps,
    TableCellProps,
    TableHeadProps,
    TableRowProps,
};
export { TableNameSpace as Table };
