import React from 'react';
import { ComponentProps } from 'react';
import { Story } from '@storybook/react';
import { Table } from './';

export default {
    title: 'Components/Table',
    component: Table,
    argTypes: {},
};

/* Stories */

const columns = [
    {
        display: 'Name',
        key: 'name',
    },
    {
        display: 'Email',
        key: 'email',
    },
    {
        display: 'Date',
        key: 'date',
    },
    {
        display: 'Phone Number',
        key: 'phone',
    },
];

const rows = [
    {
        name: 'Trevor',
        email: 'trevor@deloitte.com',
        date: '01/01/2021',
        phone: '(xxx)xxx-xxxx',
    },
    {
        name: 'Neel',
        email: 'neel@deloitte.com',
        date: '02/01/2021',
        phone: '(xxx)xxx-xxxx',
    },
];

let i = 0;
while (i < 50) {
    rows.push({
        name: `Person ${1}`,
        email: 'email@deloitte.com',
        date: '02/01/2021',
        phone: '(xxx)xxx-xxxx',
    });
    i++;
}

const Template: Story<ComponentProps<typeof Table>> = (args) => {
    return (
        <Table {...args}>
            <Table.Head>
                <Table.Row>
                    {columns.map((h) => {
                        return (
                            <Table.Cell key={h.key} title={h.display}>
                                {h.display}
                            </Table.Cell>
                        );
                    })}
                </Table.Row>
            </Table.Head>
            <Table.Body>
                {rows.map((row, rowIdx) => {
                    return (
                        <Table.Row key={rowIdx}>
                            {columns.map((column) => {
                                return (
                                    <Table.Cell key={row[column.key]}>
                                        {row[column.key]}
                                    </Table.Cell>
                                );
                            })}
                        </Table.Row>
                    );
                })}
            </Table.Body>
        </Table>
    );
};

// Default
export const Default = Template.bind({});

Default.args = {};

// Placeholder

// Disabled
