import { ComponentProps, useEffect, useState } from 'react';
import { Story, Meta } from '@storybook/react';

import { Switch } from './Switch';

export default {
    title: 'Components/Switch',
    component: Switch,
} as Meta;

/* Stories */

const Template: Story<ComponentProps<typeof Switch>> = (args) => {
    const { value, onChange, ...otherArgs } = args;

    const [activeValue, setActiveValue] = useState<boolean>(value);

    useEffect(() => {
        setActiveValue(value);
    }, [value]);

    return (
        <Switch
            value={activeValue}
            onChange={(value) => {
                setActiveValue(value);
                onChange(value);
            }}
            {...otherArgs}
        />
    );
};

export const Default = Template.bind({});

Default.args = {
    value: false,
    name: 'default',
};

export const Disabled = Template.bind({});

Disabled.args = {
    value: false,
    disabled: true,
    name: 'disabled',
};

export const Error = Template.bind({});

Error.args = {
    value: false,
    disabled: false,
    name: 'error',
    valid: false,
};
