import { ComponentProps } from 'react';
import { Story, Meta } from '@storybook/react';
import { Scroll } from './Scroll';

export default {
    title: 'Components/Scroll',
    component: Scroll,
    parameters: {
        layout: 'centered',
    },
    argTypes: {},
} as Meta;

/* Stories */

const TAGS = Array.from({ length: 100 }).map(
    (_, i, a) => `Task ${a.length - i} `,
);

const DefaultTemplate: Story<ComponentProps<typeof Scroll>> = ({ ...args }) => {
    return (
        <>
            <div
                style={{
                    width: '200px',
                    height: '200px',
                    border: '1px solid',
                }}
            >
                <Scroll {...args}>
                    <div
                        style={{
                            width: '2000px',
                            height: '2000px',
                        }}
                    >
                        Scroll
                    </div>
                </Scroll>
            </div>
        </>
    );
};

// Default
export const Default = DefaultTemplate.bind({});

Default.args = {
    children: TAGS,
};
