import { ReactNode, forwardRef, ForwardedRef } from 'react';
import { Trigger } from '@radix-ui/react-popover';

export interface PopoverTriggerProps {
    /** Content to act as the popover trigger */
    children: ReactNode;
}

/**
 * PopoverTrigger component
 */
const _PopoverTrigger = (
    props: PopoverTriggerProps,
    ref: ForwardedRef<HTMLButtonElement>,
): JSX.Element => {
    const { children } = props;

    return (
        <Trigger ref={ref} asChild={true}>
            {children}
        </Trigger>
    );
};

export const PopoverTrigger = forwardRef(_PopoverTrigger) as (
    props: PopoverTriggerProps & {
        ref?: ForwardedRef<HTMLButtonElement>;
    },
) => ReturnType<typeof _PopoverTrigger>;
