import React, { useState, useEffect } from 'react';
import { Story } from '@storybook/react';
import { Pagination } from '../Pagination';

export default {
    title: 'Components/Pagination',
    component: Pagination,
    argTypes: {},
};

/* Stories */
const Template: Story<React.ComponentProps<typeof Pagination>> = (args) => {
    const { value, onChange, ...otherArgs } = args;
    const [selectedValue, setSelectedValue] = useState(value);

    useEffect(() => {
        setSelectedValue(value);
    }, [value]);

    return (
        <Pagination
            value={selectedValue}
            onChange={(newValue) => {
                setSelectedValue(newValue);
                onChange(newValue);
            }}
            {...otherArgs}
        ></Pagination>
    );
};

//Default
export const Default = Template.bind({});

Default.args = {
    value: 1,
    total: 1000,
};

// Disabled
export const Disabled = Template.bind({});

Disabled.args = {
    ...Default.args,
    disabled: true,
};
