import { ComponentProps } from 'react';
import { Story, Meta } from '@storybook/react';

import { createTheme } from '../../stitches.config';
import { Button } from '../Button';
import { Override } from '../Override';

export default {
    title: 'Components/Override',
    component: Override,
    parameters: {
        layout: 'centered',
    },
} as Meta;

/* Stories */

const ButtonTemplate: Story<ComponentProps<typeof Override>> = (args) => {
    return (
        <div style={{ display: 'flex', gap: '0.5rem' }}>
            <div>
                <Button>Default</Button>
            </div>
            <div>
                <Override {...args}>
                    <Button>Purple</Button>
                </Override>
            </div>
        </div>
    );
};

// Purple Button
export const PurpleButton = ButtonTemplate.bind({});

PurpleButton.args = {
    theme: createTheme({
        colors: {
            'primary-5': '#9f7aea',
            'primary-4': '#9f7aea',
            'primary-3': '#9f7aea',
            'primary-2': '#9f7aea',
            'primary-1': '#9f7aea',
        },
    }),
};
