import { createContext } from 'react';

import {
    NotificationValue,
    createUseNotification,
    createNotificationProvider,
    NotificationProviderProps,
} from './NotificationContext';

export const createNotification = <S>(): {
    useNotification: () => NotificationValue<S>;
    Notification: (props: NotificationProviderProps<S>) => JSX.Element;
} => {
    // create a new context
    const NotificationContext = createContext<NotificationValue<S> | undefined>(
        undefined,
    );

    // create a new hook
    const useNotification = createUseNotification(NotificationContext);

    // create a new provider
    const Notification = createNotificationProvider(NotificationContext);

    return {
        useNotification: useNotification,
        Notification: Notification,
    };
};
