import { ReactNode, ComponentProps } from 'react';
import { Alert, AlertProps } from '../Alert';

import { createNotification } from './createNotification';

import { styled, theme } from '../../stitches.config';

const NotificationService = createNotification<{
    /** Color of the notification */
    color: AlertProps['color'];
    /** Content to pass into the notification */
    content: ReactNode;
}>();

const StyledAlert = styled(Alert, {
    width: theme.space['80'],
});

export type NotificationProps = Omit<
    ComponentProps<typeof NotificationService.Notification>,
    'render'
>;

/**
 * Notification component
 */
export const Notification = (props: NotificationProps): JSX.Element => {
    const { children, ...otherProps } = props;

    return (
        <NotificationService.Notification
            render={(notification, { color, content }, id) => (
                <StyledAlert
                    variant={'notification'}
                    color={color}
                    onClose={() => notification.remove(id)}
                >
                    {content}
                </StyledAlert>
            )}
            {...otherProps}
        >
            {children}
        </NotificationService.Notification>
    );
};

export const useNotification = NotificationService.useNotification;
