import { ComponentProps } from 'react';
import { Story } from '@storybook/react';

import { Button } from '../Button';
import { Notification, useNotification } from './';

export default {
    title: 'Components/Notification',
    component: Notification,
    parameters: {
        layout: 'centered',
    },
};

const Content = () => {
    const notification = useNotification();

    return (
        <div style={{ display: 'flex', gap: '0.5rem' }}>
            <Button
                color="primary"
                onClick={() =>
                    notification.add({
                        color: 'primary',
                        content: 'Primary Notification',
                    })
                }
            >
                Add
            </Button>
            <Button
                color="success"
                onClick={() =>
                    notification.add({
                        color: 'success',
                        content: 'Success Notification',
                    })
                }
            >
                Add
            </Button>
            <Button
                color="warning"
                onClick={() =>
                    notification.add({
                        color: 'warning',
                        content: 'Warning Notification',
                    })
                }
            >
                Add
            </Button>
            <Button
                color="error"
                onClick={() =>
                    notification.add({
                        color: 'error',
                        content: 'Error Notification',
                    })
                }
            >
                Add
            </Button>
        </div>
    );
};

/* Stories */
const Template: Story<ComponentProps<typeof Notification>> = (args) => {
    return (
        <Notification {...args}>
            <Content />
        </Notification>
    );
};

// Default
export const Default = Template.bind({});
