import { ReactNode, forwardRef, ForwardedRef } from 'react';

import { styled } from '../../stitches.config';

const StyledBody = styled('div', {
    overflow: 'auto',
    padding: '0 $4 0 $4',
});

export interface ModalBodyProps {
    /** Content to act as the modal body */
    children: ReactNode;
}

/**
 * ModalBody Component
 */
const _ModalBody = (
    props: ModalBodyProps,
    ref: ForwardedRef<HTMLDivElement>,
): JSX.Element => {
    const { children } = props;

    return <StyledBody ref={ref}>{children}</StyledBody>;
};

export const ModalBody = forwardRef(_ModalBody) as (
    props: ModalBodyProps & {
        ref?: ForwardedRef<HTMLButtonElement>;
    },
) => ReturnType<typeof _ModalBody>;
