import { ComponentPropsWithoutRef } from 'react';
import { Root } from '@radix-ui/react-dialog';

export interface ModalProps extends ComponentPropsWithoutRef<'div'> {
    /** Mark the modal in a open/closed state */
    open?: boolean;

    /** Callback triggered on open */
    onOpen?: (open: true) => void;

    /** Callback triggered on close */
    onClose?: (open: false) => void;
}

/**
 * Modal Component
 */
export const Modal = (props: ModalProps): JSX.Element => {
    const { children, open, onOpen = () => null, onClose = () => null } = props;

    return (
        <Root
            open={open}
            onOpenChange={(open) => {
                if (open) {
                    onOpen(true);
                } else {
                    onClose(false);
                }
            }}
        >
            {children}
        </Root>
    );
};
