import { ComponentProps, useState } from 'react';
import { Story, Meta } from '@storybook/react';

import { Form } from '../Form';
import { Grid } from '../Grid';
import { Button } from '../Button';
import { Input } from '../Input';
import { Select } from '../Select';
import { Datepicker } from '../Datepicker';

import { Modal } from './';
import { ModalContentProps } from './ModalContent';

export default {
    title: 'Components/Modal',
    component: Modal,
    subcomponents: {
        Body: Modal.Body,
        Content: Modal.Content,
        Close: Modal.Close,
        Header: Modal.Header,
        Footer: Modal.Footer,
        Trigger: Modal.Trigger,
    },
    parameters: {
        layout: 'centered',
    },
    argTypes: {},
} as Meta;

/* Stories */

const DefaultTemplate: Story<ComponentProps<typeof Modal>> = ({ ...args }) => {
    const [modalOpenState, setModalOpenState] = useState(false);

    return (
        <Modal
            {...args}
            open={modalOpenState}
            onOpen={(open) => {
                setModalOpenState(open);
            }}
            onClose={(open) => {
                setModalOpenState(open);
            }}
        >
            <Modal.Trigger>
                <Button>Open</Button>
            </Modal.Trigger>
            <Modal.Content>
                <Modal.Header>Title</Modal.Header>
                <Modal.Body>
                    <Form>
                        <Grid>
                            <Grid.Item>
                                <Form.Field label="Name">
                                    <Input />
                                </Form.Field>
                            </Grid.Item>
                            <Grid.Item>
                                <Form.Field label="Address">
                                    <Input />
                                </Form.Field>
                            </Grid.Item>
                            <Grid.Item>
                                <Form.Field label="Type">
                                    <Select options={['A', 'B', 'C', 'D']} />
                                </Form.Field>
                            </Grid.Item>
                            <Grid.Item>
                                <Form.Field label="Date">
                                    <Datepicker />
                                </Form.Field>
                            </Grid.Item>
                        </Grid>
                    </Form>
                </Modal.Body>
                <Modal.Footer>
                    <Modal.Close>
                        <Button>Close</Button>
                    </Modal.Close>
                </Modal.Footer>
            </Modal.Content>
        </Modal>
    );
};

const OverflowTemplate: Story<ComponentProps<typeof Modal>> = ({ ...args }) => {
    const [modalOpenState, setModalOpenState] = useState(false);

    return (
        <Modal
            {...args}
            open={modalOpenState}
            onOpen={(open) => {
                setModalOpenState(open);
            }}
            onClose={(open) => {
                setModalOpenState(open);
            }}
        >
            <Modal.Trigger>
                <Button>Open</Button>
            </Modal.Trigger>
            <Modal.Content>
                <Modal.Header description={'Description'}>Title</Modal.Header>
                <Modal.Body>
                    <Form>
                        <Grid>
                            <Grid.Item>
                                <Form.Field label="Name">
                                    <Input />
                                </Form.Field>
                            </Grid.Item>
                            <Grid.Item>
                                <Form.Field label="Address">
                                    <Input />
                                </Form.Field>
                            </Grid.Item>
                            <Grid.Item>
                                <Form.Field label="Type">
                                    <Select options={['A', 'B', 'C', 'D']} />
                                </Form.Field>
                            </Grid.Item>
                            <Grid.Item>
                                <Form.Field label="Date">
                                    <Datepicker />
                                </Form.Field>
                            </Grid.Item>
                            <Grid.Item>
                                <Form.Field label="Name">
                                    <Input />
                                </Form.Field>
                            </Grid.Item>
                            <Grid.Item>
                                <Form.Field label="Address">
                                    <Input />
                                </Form.Field>
                            </Grid.Item>
                            <Grid.Item>
                                <Form.Field label="Type">
                                    <Select options={['A', 'B', 'C', 'D']} />
                                </Form.Field>
                            </Grid.Item>
                            <Grid.Item>
                                <Form.Field label="Date">
                                    <Datepicker />
                                </Form.Field>
                            </Grid.Item>
                            <Grid.Item>
                                <Form.Field label="Name">
                                    <Input />
                                </Form.Field>
                            </Grid.Item>
                            <Grid.Item>
                                <Form.Field label="Address">
                                    <Input />
                                </Form.Field>
                            </Grid.Item>
                            <Grid.Item>
                                <Form.Field label="Type">
                                    <Select options={['A', 'B', 'C', 'D']} />
                                </Form.Field>
                            </Grid.Item>
                            <Grid.Item>
                                <Form.Field label="Date">
                                    <Datepicker />
                                </Form.Field>
                            </Grid.Item>
                        </Grid>
                    </Form>
                </Modal.Body>
                <Modal.Footer>
                    <Modal.Close>
                        <Button variant="text">Close</Button>
                    </Modal.Close>
                    <Modal.Close>
                        <Button>Submit</Button>
                    </Modal.Close>
                </Modal.Footer>
            </Modal.Content>
        </Modal>
    );
};

const MultiSizeTemplate: Story<ComponentProps<typeof Modal>> = ({
    ...args
}) => {
    const [modalOpenState, setModalOpenState] = useState(false);
    const [modalSize, setModalSize] = useState<ModalContentProps['size']>('md');

    return (
        <Modal
            {...args}
            open={modalOpenState}
            onOpen={(open) => {
                setModalOpenState(open);
            }}
            onClose={(open) => {
                setModalOpenState(open);
            }}
        >
            <Modal.Trigger>
                <Button onClick={() => setModalSize('sm')}>sm</Button>
            </Modal.Trigger>
            <Modal.Trigger>
                <Button onClick={() => setModalSize('md')}>md</Button>
            </Modal.Trigger>
            <Modal.Trigger>
                <Button onClick={() => setModalSize('lg')}>lg</Button>
            </Modal.Trigger>
            <Modal.Content size={modalSize}>
                <Modal.Header description={'Description'}>Title</Modal.Header>
                <Modal.Body>
                    <Form>
                        <Grid>
                            <Grid.Item>
                                <Form.Field label="Name">
                                    <Input />
                                </Form.Field>
                            </Grid.Item>
                            <Grid.Item>
                                <Form.Field label="Address">
                                    <Input />
                                </Form.Field>
                            </Grid.Item>
                            <Grid.Item>
                                <Form.Field label="Type">
                                    <Select options={['A', 'B', 'C', 'D']} />
                                </Form.Field>
                            </Grid.Item>
                            <Grid.Item>
                                <Form.Field label="Date">
                                    <Datepicker />
                                </Form.Field>
                            </Grid.Item>
                            <Grid.Item>
                                <Form.Field label="Name">
                                    <Input />
                                </Form.Field>
                            </Grid.Item>
                            <Grid.Item>
                                <Form.Field label="Address">
                                    <Input />
                                </Form.Field>
                            </Grid.Item>
                            <Grid.Item>
                                <Form.Field label="Type">
                                    <Select options={['A', 'B', 'C', 'D']} />
                                </Form.Field>
                            </Grid.Item>
                            <Grid.Item>
                                <Form.Field label="Date">
                                    <Datepicker />
                                </Form.Field>
                            </Grid.Item>
                            <Grid.Item>
                                <Form.Field label="Name">
                                    <Input />
                                </Form.Field>
                            </Grid.Item>
                            <Grid.Item>
                                <Form.Field label="Address">
                                    <Input />
                                </Form.Field>
                            </Grid.Item>
                            <Grid.Item>
                                <Form.Field label="Type">
                                    <Select options={['A', 'B', 'C', 'D']} />
                                </Form.Field>
                            </Grid.Item>
                            <Grid.Item>
                                <Form.Field label="Date">
                                    <Datepicker />
                                </Form.Field>
                            </Grid.Item>
                        </Grid>
                    </Form>
                </Modal.Body>
                <Modal.Footer>
                    <Modal.Close>
                        <Button variant="text" style={{ marginRight: '.5rem' }}>
                            Close
                        </Button>
                    </Modal.Close>

                    <Modal.Close>
                        <Button>Submit</Button>
                    </Modal.Close>
                </Modal.Footer>
            </Modal.Content>
        </Modal>
    );
};

// Default
export const Default = DefaultTemplate.bind({});

Default.args = {
    id: 'default',
};

export const Overflow = OverflowTemplate.bind({});

Overflow.args = {
    id: 'overflow',
};

export const Size = MultiSizeTemplate.bind({});

Size.args = {
    id: 'size',
};
