import { ComponentProps } from 'react';
import { Story } from '@storybook/react';

import { Loading } from '.';

export default {
    title: 'Components/Loading',
    component: Loading,
    parameters: {
        layout: 'centered',
    },
};

/* Stories */
const Template: Story<ComponentProps<typeof Loading>> = (args) => {
    return (
        <div
            style={{
                position: 'relative',
                height: '600px',
                width: '600px',
                border: '1px solid grey',
            }}
        >
            <Loading {...args} />
        </div>
    );
};

// Default
export const Default = Template.bind({});

Default.args = {
    open: true,
    message: 'Loading',
    description: 'Text '.repeat(10),
};
