import { ComponentProps } from 'react';
import { Story, Meta } from '@storybook/react';
import { IconButton } from './IconButton';
import { Icon } from '../Icon';

const mdiInformation =
    'M13,9H11V7H13M13,17H11V11H13M12,2A10,10 0 0,0 2,12A10,10 0 0,0 12,22A10,10 0 0,0 22,12A10,10 0 0,0 12,2Z';

export default {
    title: 'Components/IconButton',
    component: IconButton,
    argTypes: {
        color: {
            control: {
                type: 'select',
                required: false,
            },
            table: {
                defaultValue: {
                    summary: 'primary',
                },
            },
        },
        size: {
            control: {
                type: 'select',
                required: false,
            },
            table: {
                defaultValue: {
                    summary: 'md',
                },
            },
        },
    },
} as Meta;

/* Stories */
const Template: Story<ComponentProps<typeof IconButton>> = (args) => (
    <IconButton {...args} />
);

const MultiSizeTemplate: Story<ComponentProps<typeof IconButton>> = (args) => (
    <>
        <div style={{ display: 'flex', gap: '0.5rem' }}>
            <IconButton size="sm" {...args} />
            <IconButton size="md" {...args} />
            <IconButton size="lg" {...args} />
        </div>
    </>
);

// Default
export const Default = Template.bind({});

Default.args = {
    children: <Icon path={mdiInformation} />,
    disabled: false,
};

// Disabled
export const Disabled = MultiSizeTemplate.bind({});

Disabled.args = {
    ...Default.args,
    disabled: true,
};

Disabled.argTypes = {
    size: {
        control: false,
    },
};

// Primary
export const Primary = MultiSizeTemplate.bind({});

Primary.args = {
    ...Default.args,
    color: 'primary',
};

Primary.argTypes = {
    size: {
        control: false,
    },
};

// Success
export const Success = MultiSizeTemplate.bind({});

Success.args = {
    ...Default.args,
    color: 'success',
};

Success.argTypes = {
    size: {
        control: false,
    },
};

// Warning
export const Warning = MultiSizeTemplate.bind({});

Warning.args = {
    ...Default.args,
    color: 'warning',
};

Warning.argTypes = {
    size: {
        control: false,
    },
};

// Error
export const Error = MultiSizeTemplate.bind({});

Error.args = {
    ...Default.args,
    color: 'error',
};

Error.argTypes = {
    size: {
        control: false,
    },
};

// Grey
export const Grey = MultiSizeTemplate.bind({});

Grey.args = {
    ...Default.args,
    color: 'grey',
};

Grey.argTypes = {
    size: {
        control: false,
    },
};

// Sizes
export const Size = MultiSizeTemplate.bind({});

Size.args = {
    ...Default.args,
};

Size.argTypes = {
    size: {
        control: false,
    },
};
