import { createContext, useContext } from 'react';

import type { StitchesCSS } from '../../stitches.config';

export type GridValue = {
    /** Number of columns in the grid */
    columns: number;

    /** Size of the gutter */
    gutterX: StitchesCSS['padding'];

    /** Size of the gutter */
    gutterY: StitchesCSS['padding'];
};

/**
 * Grid Context
 */
export const GridContext = createContext<GridValue | undefined>(undefined);

/**
 * Access the current Grid's context
 *
 * @param values - current values
 *
 * @returns the GridValue
 */
export function useGrid(): GridValue {
    const context = useContext(GridContext);
    if (context === undefined) {
        throw new Error('useGrid must be used within a Grid');
    }

    return context;
}
