import { ComponentProps, Fragment } from 'react';
import { Story } from '@storybook/react';

import { styled } from '../../stitches.config';
import { Grid } from './';

const StyledItem = styled('div', {
    background: '$primary-4',
    height: '$space$8',
    width: '$space$full',
});

export default {
    title: 'Components/Grid',
    component: Grid,
    subcomponents: {
        Grid: Grid,
        Item: Grid.Item,
    },
};

/* Stories */
const Template: Story<ComponentProps<typeof Grid>> = (args) => {
    const grid = [
        [12],
        [6, 6],
        [4, 4, 4],
        [3, 3, 3, 3],
        [2, 2, 2, 2, 2, 2],
        [1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1],
        [undefined],
    ];

    return (
        <Grid {...args}>
            {grid.map((r, rIdx) => {
                return (
                    <Fragment key={rIdx}>
                        {r.map((c, cIdx) => {
                            return (
                                <Grid.Item span={c} key={cIdx}>
                                    <StyledItem></StyledItem>
                                </Grid.Item>
                            );
                        })}
                    </Fragment>
                );
            })}
        </Grid>
    );
};

const ResponsiveTemplate: Story<ComponentProps<typeof Grid>> = (args) => {
    return (
        <Grid {...args}>
            <Grid.Item responsive={{ sm: 6, md: 4, lg: 3 }}>
                <StyledItem></StyledItem>
            </Grid.Item>
            <Grid.Item responsive={{ sm: 6, md: 4, lg: 3 }}>
                <StyledItem></StyledItem>
            </Grid.Item>
            <Grid.Item responsive={{ sm: 6, md: 4, lg: 3 }}>
                <StyledItem></StyledItem>
            </Grid.Item>
            <Grid.Item responsive={{ sm: 6, md: 4, lg: 3 }}>
                <StyledItem></StyledItem>
            </Grid.Item>
        </Grid>
    );
};

// Default
export const Default = Template.bind({});

Default.args = {};

// Default
export const Reponsive = ResponsiveTemplate.bind({});

ResponsiveTemplate.args = {};
