import { ReactNode } from 'react';

import { FormContext, useForm, FormValue } from './FormContext';

export interface FormGroupProps {
    /** Children to render */
    children: ReactNode;

    /** Layout of the form */
    layout?: FormValue['layout'];

    /** Options to wrap the label with */
    labelOptions?: FormValue['labelOptions'];
}

export const FormGroup = (props: FormGroupProps): JSX.Element => {
    const { children, layout = 'vertical', labelOptions = {} } = props;

    // get the form field and override the options
    const form = useForm({ labelOptions: labelOptions, layout: layout });

    return <FormContext.Provider value={form}>{children}</FormContext.Provider>;
};
