import { ComponentPropsWithRef, forwardRef, ForwardedRef } from 'react';

import { styled } from '../../stitches.config';

const StyledDescription = styled('div', {
    color: '$grey-1',
    display: 'block',
    fontSize: '$xs',
    variants: {
        nowrap: {
            true: {
                whiteSpace: 'nowrap',
                overflow: 'hidden',
                textOverflow: 'ellipsis',
            },
        },
    },
    defaultVariants: {
        nowrap: true,
    },
});

export interface FormDescriptionProps extends ComponentPropsWithRef<'div'> {
    /** Allow the FormDescription to wrap to the next line */
    nowrap?: boolean;
}

/**
 * FormDescription component
 */
const _FormDescription = (
    props: FormDescriptionProps,
    ref: ForwardedRef<HTMLDivElement>,
): JSX.Element => {
    const { children, ...otherProps } = props;

    return (
        <StyledDescription ref={ref} {...otherProps}>
            {children}
        </StyledDescription>
    );
};

export const FormDescription = forwardRef(_FormDescription) as (
    props: FormDescriptionProps & {
        ref?: ForwardedRef<HTMLDivElement>;
    },
) => ReturnType<typeof _FormDescription>;
