import { ComponentPropsWithoutRef } from 'react';

import { FormContext, FormValue } from './FormContext';

export interface FormProps
    extends Omit<ComponentPropsWithoutRef<'form'>, 'onSubmit'> {
    /** Layout of the form */
    layout?: FormValue['layout'];

    /** Options to wrap the label with */
    labelOptions?: FormValue['labelOptions'];

    /** Callback that is triggered on submit of the form */
    onSubmit?: () => void;
}

export const Form = (props: FormProps): JSX.Element => {
    const {
        children,
        layout = 'vertical',
        labelOptions = {},
        onSubmit = () => null,
        ...otherProps
    } = props;

    // construct the value to pass to the form
    const value = {
        layout: layout,
        labelOptions: labelOptions,
    };

    // TODO: wrap with a form library?
    return (
        <FormContext.Provider value={value}>
            <form onSubmit={onSubmit} {...otherProps}>
                {children}
            </form>
        </FormContext.Provider>
    );
};
