import { ComponentProps } from 'react';
import { Story } from '@storybook/react';

import { Form } from './';
import { Grid } from '../Grid';
import { Input } from '../Input';
import { Textarea } from '../Textarea';

export default {
    title: 'Components/Form',
    component: Form,
    subcomponents: {
        Form: Form,
        Group: Form.Group,
        Field: Form.Field,
    },
};

/* Stories */
const Template: Story<ComponentProps<typeof Form>> = (args) => {
    return (
        <Form {...args}>
            <Grid>
                <Grid.Item>
                    <Form.Field label="Enter Text">
                        <Input />
                    </Form.Field>
                </Grid.Item>
                <Grid.Item>
                    <Form.Field label="Enter Text" description="Description">
                        <Textarea />
                    </Form.Field>
                </Grid.Item>
                <Grid.Item>
                    <Form.Field label="Enter Text" error="Error">
                        <Input />
                    </Form.Field>
                </Grid.Item>
                <Grid.Item>
                    <Form.Field
                        label="Enter Text"
                        description="description"
                        error="Error"
                    >
                        <Input />
                    </Form.Field>
                </Grid.Item>
            </Grid>
        </Form>
    );
};

const MixedTemplate: Story<ComponentProps<typeof Form>> = (args) => {
    return (
        <Form {...args}>
            <Grid>
                <Grid.Item>
                    <Form.Field label="Enter Text">
                        <Input />
                    </Form.Field>
                </Grid.Item>
                <Grid.Item>
                    <Form.Field label="Enter Text" description="Description">
                        <Textarea />
                    </Form.Field>
                </Grid.Item>
                <Form.Group layout="vertical">
                    <Grid.Item span={4}>
                        <Form.Field label="Enter Text">
                            <Input />
                        </Form.Field>
                    </Grid.Item>
                    <Grid.Item span={4}>
                        <Form.Field label="Enter Text">
                            <Input />
                        </Form.Field>
                    </Grid.Item>
                    <Grid.Item span={4}>
                        <Form.Field label="Enter Text">
                            <Input />
                        </Form.Field>
                    </Grid.Item>
                </Form.Group>
            </Grid>
        </Form>
    );
};

// Default
export const Default = Template.bind({});

Default.args = {};

// Horizontal
export const Horizontal = Template.bind({});

Horizontal.args = {
    layout: 'horizontal',
};

// Horizontal
export const Mixed = MixedTemplate.bind({});

Mixed.args = {
    layout: 'horizontal',
};
