import React, { forwardRef } from 'react';
import { styled, StitchesCSS } from '../../stitches.config';

const StyledFlex = styled('div', {
    display: 'flex',
});

export interface FlexProps extends React.ComponentPropsWithRef<'div'> {
    /** Direction of the flex box */
    direction?: StitchesCSS['flexDirection'];

    /** Justify the content */
    justify?: StitchesCSS['justifyContent'];

    /** Align the content */
    align?: StitchesCSS['alignItems'];

    /** Wrap the content */
    wrap?: StitchesCSS['flexWrap'];

    /** */
    basis?: StitchesCSS['flexBasis'];

    /** */
    grow?: StitchesCSS['flexGrow'];

    /** */
    shrink?: StitchesCSS['flexShrink'];

    /** Gap between the children */
    gap?: StitchesCSS['gap'];
}

export const Flex = forwardRef<HTMLDivElement, FlexProps>(
    (props, ref): JSX.Element => {
        const {
            children,
            direction,
            justify,
            align,
            wrap,
            basis,
            grow,
            shrink,
            gap,
            ...otherProps
        } = props;

        return (
            <StyledFlex
                ref={ref}
                css={{
                    flexDirection: direction,
                    justifyContent: justify,
                    alignItems: align,
                    flexWrap: wrap,
                    flexBasis: basis,
                    flexGrow: grow,
                    flexShrink: shrink,
                    gap: gap,
                }}
                {...otherProps}
            >
                {children}
            </StyledFlex>
        );
    },
);

Flex.displayName = 'Flex';
