import { ComponentProps } from 'react';
import { Story } from '@storybook/react';

import { Flex } from '.';

export default {
    title: 'Components/Flex',
    component: Flex,
    parameters: {
        layout: 'centered',
    },
};

/* Stories */
const Template: Story<ComponentProps<typeof Flex>> = (args) => {
    return (
        <Flex {...args}>
            <div>Item</div>
            <div>Item</div>
            <div>Item</div>
        </Flex>
    );
};

// Default
export const Default = Template.bind({});

Default.args = {};
