import { Dropdown, DropdownProps } from './Dropdown';
import { DropdownContent, DropdownContentProps } from './DropdownContent';
import { DropdownItem, DropdownItemProps } from './DropdownItem';
import { DropdownLabel, DropdownLabelProps } from './DropdownLabel';
import { DropdownSeperator, DropdownSeperatorProps } from './DropdownSeperator';
import { DropdownSubMenu, DropdownSubMenuProps } from './DropdownSubMenu';
import {
    DropdownSubMenuContent,
    DropdownSubMenuContentProps,
} from './DropdownSubMenuContent';
import {
    DropdownSubMenuTrigger,
    DropdownSubMenuTriggerProps,
} from './DropdownSubMenuTrigger';
import { DropdownTrigger, DropdownTriggerProps } from './DropdownTrigger';

const DropdownNameSpace = Object.assign(Dropdown, {
    Content: DropdownContent,
    Item: DropdownItem,
    Label: DropdownLabel,
    Seperator: DropdownSeperator,
    SubMenu: DropdownSubMenu,
    SubMenuContent: DropdownSubMenuContent,
    SubMenuTrigger: DropdownSubMenuTrigger,
    Trigger: DropdownTrigger,
});

export type {
    DropdownProps,
    DropdownContentProps,
    DropdownItemProps,
    DropdownLabelProps,
    DropdownSeperatorProps,
    DropdownSubMenuProps,
    DropdownSubMenuContentProps,
    DropdownSubMenuTriggerProps,
    DropdownTriggerProps,
};
export { DropdownNameSpace as Dropdown };
