import { ComponentPropsWithRef, forwardRef, ForwardedRef } from 'react';
import { SubTrigger } from '@radix-ui/react-dropdown-menu';

import { styled, theme } from '../../stitches.config';

const StyledDropdownSubMenuTrigger = styled(SubTrigger, {
    display: 'flex',
    alignItems: 'center',
    flex: '1 1 0',
    minHeight: theme.space['8'],
    padding: `0 ${theme.space['4']}`,
    color: theme.colors['grey-1'],
    backgroundColor: theme.colors['base'],
    cursor: 'pointer',
    outline: 'none',
    overflow: 'hidden',
    fontSize: theme.fontSizes.sm,
    borderRadius: theme.radii.default,
    '&[data-disabled]': {
        color: theme.colors['grey-3'],
        pointerEvents: 'none',
    },
    '&[data-highlighted]': {
        background: theme.colors['primary-5'],
    },
    '&[data-state="open"]': {
        color: theme.colors['primary-1'],
    },
});

export interface DropdownSubMenuTriggerProps
    extends Omit<ComponentPropsWithRef<'div'>, 'onSelect'> {
    /** Mark the item in a disabled/enabled state */
    disabled?: boolean;
}

/**
 * DropdownSubMenuTrigger component
 */
const _DropdownSubMenuTrigger = (
    props: DropdownSubMenuTriggerProps,
    ref: ForwardedRef<HTMLDivElement>,
): JSX.Element => {
    const { children, disabled = false, ...otherProps } = props;

    return (
        <StyledDropdownSubMenuTrigger
            ref={ref}
            disabled={disabled}
            {...otherProps}
        >
            {children}
        </StyledDropdownSubMenuTrigger>
    );
};

export const DropdownSubMenuTrigger = forwardRef(_DropdownSubMenuTrigger) as (
    props: DropdownSubMenuTriggerProps & {
        ref?: ForwardedRef<HTMLDivElement>;
    },
) => ReturnType<typeof _DropdownSubMenuTrigger>;
